/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Log.c -- manages the logfile of Nessus
 *
 */
 


#include <includes.h>
#include <stdarg.h>
#ifndef _CYGWIN_
#include <syslog.h>
#endif

#ifdef NESSUSNT
#include <time.h>
#include "wstuff.h"
#endif
#include "comm.h"
#include "rtree.h"
#include "utils.h"
#include "log.h"


#ifdef _CYGWIN_
static char *log_ident = 0;
static int log_sock = -1;
static int my_openlog(const char *ident, int ignored, int ignored2) {
	struct sockaddr_in sa;

	log_ident = strdup(ident);
	log_sock = socket(AF_INET, SOCK_DGRAM, 0);
	if(log_sock < 0)
		return;
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	sa.sin_port = htons(514);
	if(connect(log_sock, (struct sockaddr *) &sa, sizeof(sa)) < 0) {
		perror("connect");
		shutdown(log_sock, 2);
		close(log_sock);
		log_sock = -1;
	}
}
static void my_closelog() {
	if(log_ident) {
		free(log_ident);
		log_ident = 0;
	}
	if(log_sock >= 0) {
		shutdown(log_sock, 2);
		close(log_sock);
		log_sock = -1;
	}
}

static int my_syslog(int priority, char *fmt, ...) {
  va_list param;
  char * disp = emalloc(4096);
  char * tmp;
  va_start(param, fmt);
#ifdef HAVE_VSNPRINTF
  vsnprintf(disp, 4095,fmt, param);
#else
  vsprintf(disp, fmt, param);
#endif
  while((tmp=(char*)strchr(disp, '\n')))tmp[0]=' ';
  if(disp[strlen(disp)-1]=='\n')disp[strlen(disp)-1]=0;
  if(log_sock >= 0)
  {
   char * timestr;
   time_t t;
   FILE *log = fdopen(log_sock, "w");
   
   t = time(NULL);
   tmp = ctime(&t);
   timestr = emalloc(strlen(tmp)+1);
   strncpy(timestr, tmp, strlen(tmp));
   timestr[strlen(timestr)-1]=0;
#ifndef USE_PTHREADS
   fprintf(log, "[%s][%d] %s\n", timestr, getpid(), disp);
#else 
   fprintf(log, "[%s][%d.%d] %s\n", timestr, getpid(), pthread_self(), disp);
#endif
   fflush(log);
   efree(&timestr);
  }
  efree(&disp);
  va_end(param);  
}
#define openlog		my_openlog
#define syslog		my_syslog
#define closelog	my_closelog
#define LOG_DAEMON	(3 << 3)
#define LOG_NOTICE	5
#endif
static FILE * log;


/* 
 * initialization of the log file
 */
void 
log_init(filename)
  const char * filename;
{
  if((!filename)||(!strcmp(filename, "stderr")))log = stderr;
  else if(!strcmp(filename, "syslog")){
  	openlog("nessusd", 0, LOG_DAEMON);
	log = NULL;
	}
  else
    {
      check_symlink((char *)filename);
      log = fopen(filename, "a");
      if(!log)
	{
	  perror("fopen ");
	  print_error("Could not open the logfile, using stderr\n");
	  log = stderr;
	}
    }
#ifndef NESSUSNT
  pty_logger (log_write); /* enable pty debugging */
#endif
}



void log_close()
{
 if(log)
 {
  log_write("closing logfile");
  fclose(log);
  log = NULL;
 }
 else closelog();
}
 

/*
 * write into the logfile
 * Nothing fancy here...
 */
void 
log_write(const char * str, ...)
{
  va_list param;
  char * disp = emalloc(4096);
  char * tmp;
  va_start(param, str);
#ifdef HAVE_VSNPRINTF
  vsnprintf(disp, 4095,str, param);
#else
  vsprintf(disp, str, param);
#endif
  while((tmp=(char*)strchr(disp, '\n')))tmp[0]=' ';
  if(disp[strlen(disp)-1]=='\n')disp[strlen(disp)-1]=0;
  if(log)
  {
   char * timestr;
   time_t t;
   
   t = time(NULL);
   tmp = ctime(&t);
   timestr = emalloc(strlen(tmp)+1);
   strncpy(timestr, tmp, strlen(tmp));
   timestr[strlen(timestr)-1]=0;
#ifndef USE_PTHREADS
   fprintf(log, "[%s][%d] %s\n", timestr, getpid(), disp);
#else 
   fprintf(log, "[%s][%d.%d] %s\n", timestr, getpid(), pthread_self(), disp);
#endif
   fflush(log);
   efree(&timestr);
  }
  else syslog(LOG_NOTICE, "%s", disp);
  efree(&disp);
  va_end(param);  
}

