#
# This script was written by Vincent Renardias <vincent@efb2.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10698);
 script_version ("$Revision: 1.7 $");
 name["english"] = "WebLogic Server /%00/ bug";
 name["francais"] = "WebLogic Server /%00/ bug";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Requesting a URL with '%00', '%2e', '%2f' or '%5c' appended to it
makes some WebLogic servers dump the listing of the page 
directory, thus showing potentially sensitive files.

An attacker may also use this flaw to view
the source code of JSP files, or other dynamic content.

Reference : http://www.securityfocus.com/bid/2513
Risk factor : High
Solution : upgrade to WebLogic 6.0 with Service Pack 1";

 script_description(english:desc["english"]);
 
 summary["english"] = "Make a request like http://www.example.com/%00/";
 summary["francais"] = "Fait une requte du type http://www.example.com/%00/";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Vincent Renardias",
		francais:"Ce script est Copyright (C) 2001 Vincent Renardias");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
jsp1 = "<%";
jsp2 = "%>";
if(!port) port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = http_get(item:"/%00/", port:port);
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:100000);
  if( (jsp1 >< data) && (jsp2 >< data))
  {
   security_hole(port);
  }
  close(soc);
 }

 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = http_get(item:"/%2e/", port:port);
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:100000);
  if( (jsp1 >< data) && (jsp2 >< data))
  {
   security_hole(port);
  }
  close(soc);
 }

 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = http_get(item:"/%2f/", port:port);
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:100000);
  if( (jsp1 >< data) && (jsp2 >< data))
  {
   security_hole(port);
  }
  close(soc);
 }

 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = http_get(item:"/%5c/", port:port);
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:100000);
  if( (jsp1 >< data) && (jsp2 >< data))
  {
   security_hole(port);
  }
  close(soc);
 }

}
