#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10758);
 script_version ("$Revision: 1.4 $");
 name["english"] = "Check for VNC HTTP";
 name["francais"] = "Check for VNC HTPP";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote server is running VNC.
VNC permits a console to be displayed remotely.

Solution: Disable VNC access from the network by 
using a firewall, or stop VNC service if not needed.

Risk factor : Medium";



 desc["francais"] = "
Le serveur distant fait tourner VNC.
VNC permet d'acceder la console a distance.

Solution: Protgez l'accs  VNC grace  un firewall,
ou arretez le service VNC si il n'est pas desire.

Facteur de risque : Moyen";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Detects the presence of VNC HTTP";
 summary["francais"] = "Vrifie la prsence de VNC HTTP";
 
 script_summary(english:summary["english"],
francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com",
                francais:"Ce script est Copyright (C) 2001 Alert4Web.com");
 family["english"] = "Backdoors";
 family["francais"] = "Backdoors";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 5800, 5801, 5802);
 exit(0);
}

#
# The script code starts here
#

function probe(port)
{
 banner = get_kb_item(string("www/banner/", port));
 if(!banner)
 {
  if(get_port_state(port))
  {
   soc = open_sock_tcp(port);
   if(soc)
   {
    req = http_get(item:"/", port:port);
    send(socket:soc, data:req);
    banner = recv(socket:soc, length:1024);
    close(soc);
   }
  }
 }
 if(banner)
 {
  if (("vncviewer.jar" >< banner) || ("vncviewer.class" >< banner))
   security_warning(port);
 }
}


port = get_kb_item("Services/www");
if(port)probe(port:port);
else
{
 for (port=5800; port <= 5802; port = port+1) {
  probe(port:port);
 }
}
