#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

default_domain = "nessus.org";


if(description)
{
 script_id(10955);
 script_version ("$Revision: 1.1 $");
 name["english"] = "Third party domain";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Several checks need to use a third party host/domain 
name to work properly.

The checks that rely on this are SMTP or DNS relay checks.

By default, nessus.org is being used. However, under some
circumstances, this may make leak packets from your network
to this domain, thus compromising the privacy of your tests.

While the owner of 'nessus.org' is not known to keep logs of
such packet traces, you may want to change this value to
maximize your privacy.

Note that you absolutely need this option to be set to a 
*third party* domain. This means a domain that has *nothing
to do* with the domain name of the network you are testing.

Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Third party hosts to use";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SETTINGS);
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 family["english"] = "Settings";
 family["francais"] = "Configuration";
 script_family(english:family["english"], francais:family["francais"]);
 
 script_add_preference(name:"Third party domain :", type:"entry", value:default_domain);
 

 exit(0);
}

domain = script_get_preference("Third party domain :");

if(!domain)domain = default_domain;
set_kb_item(name:"Settings/third_party_domain", value:domain);
