#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10910);
 script_version("$Revision: 1.1 $");
 name["english"] = "Obtains local user information";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script requests informations about each local NT user
and stores it in the KB
Risk factor : None";



 script_description(english:desc["english"]);
 
 summary["english"] = "Implements NetUserGetInfo()";

 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 family["english"] = "Windows : User management";
  
 script_family(english:family["english"]);
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", 
		     "smb_sid2localuser.nasl",
		     "smb_host2sid.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/LocalUsers/enumerated", "SMB/host_sid");
 script_require_ports(139);
 exit(0);
}

#-------------------------------------------------------------#
# Transform the sid string to its hex value                   #
#-------------------------------------------------------------#
function sid2hex(s)
{
 sum = "";
 
 s1 = strstr(s, "-");
 s1 = s - s1;

 
 hi =  s1 / 256;
 low = s1 % 256;
 
 sid = raw_string(0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 
 		  0x00, 0x00, 0x00, 0x00);
		  
 sid = sid + raw_string(hi, low);
 
 start = strlen(s1);
 len = strlen(s) + 1;
 for(i=start;i<len;i=i+1)
  {
   if(s[i]=="-")
   {
    l1  = sum % 256;
    sum = sum / 256;
    l2  = sum % 256;
    sum = sum / 256;
    l3  = sum % 256;
    sum = sum / 256;
    l4  = sum % 256;
    
    sid = sid + raw_string(l1, l2, l3, l4);
    sum = "";
   }
   else sum = string(sum, s[i]);
  }
    l1  = sum % 256;
    sum = sum / 256;
    l2  = sum % 256;
    sum = sum / 256;
    l3  = sum % 256;
    sum = sum / 256;
    l4  = sum % 256;
    
    sid = sid + raw_string(l1, l2, l3, l4);
  return(sid);
}




include("smb_nt.inc");



soc = open_sock_tcp(139);
if(!soc)exit(0);

login = get_kb_item("SMB/login");
pass  = get_kb_item("SMB/password");
dom   = get_kb_item("SMB/domain");


# we need the SID of the host
sid = get_kb_item("SMB/host_sid");
if(!sid)exit(0);


x = strstr(sid, " : ");
sidx = x - " : ";

# conversion string -> hex
sid = sid2hex(s:sidx);





if(!login)login = "";
if(!pass) pass = "";
if(!dom) dom = "";

name = get_kb_item("SMB/name");

r = smb_session_request(soc:soc, remote:name);
if(!r){
	#display("smb_session_request failed\n");
	exit(0);
	}
	
if(!smb_neg_prot(soc:soc))exit(0);	
r = smb_session_setup(soc:soc, login:login, password:pass, domain:dom);
if(!r){
	#display("Session setup failed\n");
	exit(0);
	}

uid = session_extract_uid(reply:r);

#
# Connect to the remote IPC and extract the TID
# we are attributed
#      
r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
# extract our tree id
tid = tconx_extract_tid(reply:r);


#display("TID = ", tid, "\n");

pipe = OpenPipeToSamr(	soc:soc, 
		      	uid:uid, 
		      	tid:tid, 
		      	name:tolower(name));
		      
#display("PIPE = ", pipe, "\n");
if(!pipe)exit(0);

samrhdl = SamrConnect2(	soc:soc, 
		       	uid:uid,
		       	tid:tid, 
		       	pipe:pipe, 
		       	name:name
		      );

if(!samrhdl)exit(0);

samrhdl =
	SamrOpenDomain(	soc:soc, 
			uid:uid, 
			tid:tid, 
			pipe:pipe, 
			samrhdl:samrhdl,
			sid:sid
		       );		  
if(!samrhdl)exit(0);

count = 1;
login = get_kb_item(string("SMB/LocalUsers/", count));

while(login)
{
rid = SamrLookupNames(  soc:soc, 
			uid:uid, 
			tid:tid, 
			pipe:pipe, 
			domhdl:samrhdl,
			name:login
		     );	


usrhdl = SamrOpenUser(	soc:soc, 
			uid:uid, 
			tid:tid, 
			pipe:pipe, 
			samrhdl:samrhdl,
	 		rid:rid
		     );
			
if(usrhdl)
{			
r = SamrQueryUserInfo(	soc:soc, 
	     	  	uid:uid,
		  	tid:tid,
		  	pipe:pipe,
		  	usrhdl:usrhdl
		  );
		  
if(r)_SamrDecodeUserInfo(info:r, count:count, type:"LocalUsers");
}
count = count + 1;
login = get_kb_item(string("SMB/LocalUsers/", count));
}
