

if(description)
{
 script_id(10642);
 script_version ("$Revision: 1.11 $");
 
 name["english"] = "SMB Registry : SQL7 Patches";
 
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote SQL server seems to be vulnerable to the
SQL abuse vulnerability described in technet article
256052. This problem allows an attacker who has to ability
to execute SQL queries on this host to gain elevated privileges.

Solution : See http://www.microsoft.com/technet/support/kb.asp?ID=256052
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if a key exists and is set";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Intranode <plugin@intranode.com>");
 family["english"] = "Windows";

 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", "smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_access");
 script_require_ports(139);
 exit(0);
}

include("smb_nt.inc");



#---------------------------------------------------------------------#
# Get an item of type reg_sz from the key                             #
#---------------------------------------------------------------------#

function registry_get_item_dword(soc, uid, tid, pipe, item, reply)
{
 item_len = strlen(item) + 1;
 item_len_lo = item_len % 256;
 item_len_hi = item_len / 256;
 
 uc2 = unicode2(data:item);
 len = 188 + strlen(uc2);
 len_lo = len % 256;
 len_hi = len / 256;
 
 tid_low = tid % 256;
 tid_high = tid / 256;
 uid_low = uid % 256;
 uid_high = uid / 256;
 pipe_low = pipe % 256;
 pipe_high = pipe / 256;
 
 bcc = 121 + strlen(uc2);
 bcc_lo = bcc % 256;
 bcc_hi = bcc / 256;
 
 y = 80 + strlen(uc2);
 y_lo = y % 256;
 y_hi = y / 256;
 
 z = 104 + strlen(uc2);
 z_lo = z % 256;
 z_hi = z / 256;
 req = raw_string(0x00, 0x00,
 		  len_hi, len_lo, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x80, 0x1D, 0x83,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, z_lo, z_hi, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, z_lo, z_hi, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, bcc_lo, bcc_hi, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, z_lo, z_hi,
		  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, y_lo, y_hi,
		  0x00, 0x00, 0x00, 0x00, 0x11, 0x00);
		  
 magic = raw_string(ord(reply[84]));
 for(i=1;i<20;i=i+1)
 {
  magic = magic + raw_string(ord(reply[84+i]));
 }

 x = 2 + strlen(item) + strlen(item);
 x_lo = x % 256;
 x_hi = x / 256;
  
 y = y + 3;
 y_lo = y % 256;
 y_hi = y / 256;
 
  req = req + magic + raw_string(x_lo, x_hi, 0x0A, 0x02, 0x00, 0xEC,
  		0xFD, 0x7F, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, item_len_lo, item_len_hi, 0x00)
		
		+ uc2	+ 
		raw_string(0x00, 0x34, 0xFF,
		0x12, 0x00, 0xEF, 0x10, 0x40, 0x00, 0x18, 0x1E,
		0x7c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xFF,
		0x12, 0x00, 0x00, 0x04, 0x00, 0x00, 0x30, 0xFF,
		0x12, 0x00, 0x00, 0x00, 0x00, 0x00);
		
 send(socket:soc, data:req);
 req = smb_recv(socket:soc, length:4000);	
 return(req);
}		  

#------------------------------------------------------#
# Decode the reply from the registry                   #
#------------------------------------------------------#

function registry_decode_dword(data)
{

 len = ord(data[2])*256;
 len = len + ord(data[3]);
 if(len < 128)return(FALSE);
 
 data_offset = ord(data[52])*256;
 data_offset = data_offset + ord(data[51]) + 4;
 data_len = ord(data[data_offset+43]);
 data_len = data_len * 256;
 data_len = data_len + ord(data[data_offset+44]);
 index = data_offset + 48;
 o = "";
 
 
 for(i=0;i<data_len;i=i+1)
 {
   o = o + raw_string(ord(data[index+i]));
 }
 return(o);
}
			  
		 
#---------------------------------------------------------------------#
# registry_get_dword()						      #
#---------------------------------------------------------------------#


function registry_get_dword(key, item)
{

name = get_kb_item("SMB/name");
if(!name)return(FALSE);


if(!get_port_state(139))return(FALSE);

login = get_kb_item("SMB/login");
pass  = get_kb_item("SMB/password");

if(!login)login = "";
if(!pass) pass = "";

dom = get_kb_item("SMB/domain");
	  
soc = open_sock_tcp(139);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:name);
if(!r)return(FALSE);

#
# Negociate the protocol
#
if(!smb_neg_prot(soc:soc))return(FALSE);

#
# Set up our session
#
r = smb_session_setup(soc:soc, login:login, password:pass, domain:dom);
if(!r)return(FALSE);
# and extract our uid
uid = session_extract_uid(reply:r);

#
# Connect to the remote IPC and extract the TID
# we are attributed
#      
r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
# and extract our tree id
tid = tconx_extract_tid(reply:r);


#
# Create a pipe to \winreg
#
r = smbntcreatex(soc:soc, uid:uid, tid:tid);
if(!r)return(FALSE);
# and extract its ID
pipe = smbntcreatex_extract_pipe(reply:r);

#
# Setup things
#
r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r)return(FALSE);
r = registry_access_step_1(soc:soc, uid:uid, tid:tid, pipe:pipe);

r2 = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:r);
if(r2)
{
 r3 =  registry_get_item_dword(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:r2);
 value = registry_decode_dword(data:r3);
 return(value);
}
}





#---------------------------------------------------------------------#
# Here is our main()                                                  #
#---------------------------------------------------------------------#





function check_key(key)
{
 item = "AllowInProcess";
 value = registry_get_dword(key:key, item:item);
 if(strlen(value) == 4) 
 {
   item = "DisallowAdHocAccess";
   value = registry_get_dword(key:key, item:item);
   if((strlen(value)) == 0)
   {
     return(1);
   }
   else if(ord(value[0]) == 0)return(1);
 }
 return(0);
}


a = check_key(key:"SOFTWARE\Microsoft\MSSQLServer\Providers\MSDAORA");
if(a){security_hole(139);exit(0);}
b = check_key(key:"SOFTWARE\Microsoft\MSSQLServer\Providers\MSDASQL");
if(b){security_hole(139);exit(0);}
c = check_key(key:"SOFTWARE\Microsoft\MSSQLServerProviders\SQLOLEDB");
if(c){security_hole(139);exit(0);}
d = check_key(key:"SOFTWARE\Microsoft\MSSQLServerProviders\Microsoft.Jet.OLEDB.4.0");
if(d){security_hole(139);exit(0);}
