#
# This script was written by Tor Houghton, but I looked at "htdig" by 
# Renaud Deraison <deraison@cvs.nessus.org>
#
# Changes by rd:
# - phrasing in the report
# - pattern read
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10847);
 script_version ("$Revision: 1.2 $");
# script_cve_id("CVE-XXXX-YYYY");
 name["english"] = "SilverStream database structure";
 script_name(english:name["english"]);
 
 desc["english"] = "
It is possible to download the remote SilverStream database
structure by requesting :
	http://www.example.com/SilverStream/Meta/Tables/?access-mode=text
	
	
An attacker may use this flaw to gain more knowledge about
this host.

Risk factor : Medium
Solution : Reconfigure the server so that others
cannot view database structure";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if SilverStream database structure is visible.";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Tor Houghton");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "no404.nasl");
  script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


port = get_kb_item("Services/www");
if(!port) port = 80;
if(get_port_state(port)) {
   soc = http_open_socket(port);
   if(soc) {
      buf = string("/SilverStream/Meta/Tables/?access-mode=text");
      buf = http_get(item:buf, port:port);
      send(socket:soc,data:buf);
      rep = recv(soc,length:255);
      if("_DBProduct" >< rep)
         security_warning(port);
      close(soc);
   }
}

