
if(description)
{
 script_id(10674);
 script_version ("$Revision: 1.8 $");
 name["english"] = "Microsoft's SQL UDP Info Query";
 script_name(english:name["english"]);
 
 desc["english"] = "
The plugin sends a SQL 'ping' request to retrieve
information about the remote MS SQL database (if any)

Risk factor : Low
Solution : filter incoming traffic to this port";


 script_description(english:desc["english"]);
 
 summary["english"] = "Microsoft's SQL UDP Info Query";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 H D Moore");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The script code starts here
#

##
# data returned will look like:
#
#   xServerName;REDEMPTION;InstanceName;MSSQLSERVER;IsClustered;No;Version;8.00.194;tcp;1433;np;\\REDEMPTION\pipe\sql\query;;
#
##

# this magic info request packet
req = raw_string(0x02);


if(!get_udp_port_state(1434))exit(0);

soc = open_sock_udp(1434);


if(soc)
{
	send(socket:soc, data:req);
	r  = recv(socket:soc, length:4096);
        null = raw_string(0);
        while(null >< r)
        {
         r = r - null;
        }

	close(soc);
	if(r)
	{
	        null = raw_string(0);
		while(null >< r)
		{
		  r = r - null;
		}
 		report = string(
"Here is the reply to a MS SQL 'ping' request : \n",
r, "\n",
"It is suggested you filter incoming traffic to this port");
		security_warning(port:1434, protocol:"udp", data:report);
	}
}
