# This script was created by Jason Lidow <jason@brandx.net>
# The vulnerability was originally discovered by ts@securityoffice.net 

if(description)

{
	script_id(11005);
	script_version("$Revision 1.0 $");
	script_name(english:"LocalWeb2000 remote read");

    script_description(english:"
The remote host is running LocalWeb2000. 

Version 2.1.0 of LocalWeb2000 allows an attacker to view protected 
files on the host's computer. 

Example: http://www.vulnerableserver.com/./protectedfolder/protectedfile.htm

Solution: Contact http://www.intranet-server.co.uk for an update.
	
Risk Factor: Serious");

	script_summary(english:"Checks for LocalWeb2000");

	script_category(ACT_GATHER_INFO);

	script_copyright(english:"This script is Copyright (C) 2002 Jason Lidow <jason@brandx.net>");
	script_family(english:"Remote file access");
	script_dependencie("find_service.nes", "httpver.nasl", "no404.nasl");
	script_require_ports("Services/www", 80);
	exit(0);
}

port = get_kb_item("Services/www");
if (!port)port = 80;

banner = get_kb_item (string ("www/banner/", port));
if(!banner)
  {
    if (get_port_state(port))
      {
	soc = open_sock_tcp(port);
	if(soc)
	  {
	  req = http_get(item:"/", port:port);
	  send (socket:soc, data:req);
	  banner = recv(socket: soc, length:1024);
	  close (soc);
	  }
      }
  }
  
  

if(banner)
{
	if(egrep(pattern:"^Server: .*LocalWeb2000.*" , string:banner))
	{
	security_note(port);
	}
}
