#
# This script was written by Michel Arboi <arboi@bigfoot.com>
#
# GPL
#
# This script only checks if ports 4661-4663 are open. 
# The protocol is not documented, AFAIK
# I sniffed a eDonkey connection, but could not reproduce it. 


if(description)
{
  script_id(11022);
  script_version ("$Revision: 1.2 $");
 
  script_name(english:"eDonkey detection");
 
  desc["english"] = "
eDonkey might be running on this port. This peer to peer software
is used to share files.
1. This may be illegal.
2. You may have access to confidential files
3. It may eat too much bandwidth


Solution: disable it

Risk factor : Medium";

  script_description(english:desc["english"]);
 
  summary["english"] = "Detect eDoskey";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
  family["english"] = "Useless services";
  script_family(english:family["english"]);
  script_require_ports(8390);
  script_dependencie("find_service.nes");
  script_require_ports(4661, 4662, 4663);

  exit(0);
}

for (port = 4661; port <= 4663; port = port + 1)
{
 if(get_port_state(port))
 {
	soc = open_sock_tcp(port);
	if(soc)
	{
		security_warning(port);
		close(soc);
	}
 }
}

exit(0);
