#
# DCEMAP
#
# Does a 'portmap-like' request to the remote host, to
# to determine what DCE/RPC services are running.
#
# This code is 100% based on 'dcetest', by Dave Aitel, available
# at http://www.atstake.com.
#
# dcetest is available as a free (GPL'ed) software written
# in C.
#
# License : GPLv2
#
#


#
#TODO : extract the names of PIPEs and hosts when present
# 




if(description)
{
 script_id(10736);
 script_version ("$Revision: 1.6 $");
 
 name["english"] = "DCE Services Enumeration";
 script_name(english:name["english"]);
 
 desc["english"] = "
DCE services running on the remote can be enumerated
by connecting on port 135 and doing the appropriate
queries.

An attacker may use this fact to gain more knowledge
about the remote host.

Solution : filter incoming traffic to this port.
Risk factor : Low";



 script_description(english:desc["english"]);
 
 summary["english"] = "Enumerates the remote DCE services";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Dave Aitel (ported to NASL by rd)");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
 script_require_ports(135);
 exit(0);
}




#------------------------------------------#
# String from a buffer. Inverts the bytes  #
#------------------------------------------#
function istring_from_buffer(b)
{
 ret = "";
 l   = strlen(b);
 for(i=0;i<l;i=i+1)
 {
  hx = hex(ord(b[i]));
  hx = hx - string("0x");
  ret = string(hx, ret);
 }
 return(ret);
}

#----------------------------------#
# String from a buffer. Straight.  #
#----------------------------------#
function string_from_buffer(b)
{
 ret = "";
 l   = strlen(b);
 for(i=0;i<l;i=i+1)
 {
  hx = hex(ord(b[i]));
  hx = hx - string("0x");
  ret = string(ret, hx);
 }
 return(ret);
}


#------------------------------------------#
# Return the guid as something printable   #
#------------------------------------------#
function strguid(guid)
{
 tbuffer = "";
 tbuffer2 = "";
 tbuffer3 = "";
 tbuffer4 = "";
 tbuffer5 = "";
 
 for(i=0;i<4;i=i+1)tbuffer = string(tbuffer, raw_string(ord(guid[i])));
 for(i=0;i<2;i=i+1)tbuffer2 = string(tbuffer2, raw_string(ord(guid[i+4])));
 for(i=0;i<2;i=i+1)tbuffer3 = string(tbuffer3, raw_string(ord(guid[i+6])));
 for(i=0;i<2;i=i+1)tbuffer4 = string(tbuffer4, raw_string(ord(guid[i+8])));
 for(i=0;i<6;i=i+1)tbuffer5 = string(tbuffer5, raw_string(ord(guid[i+10])));
 _ret = string(istring_from_buffer(b:tbuffer), "-",
 	       istring_from_buffer(b:tbuffer2), "-",
	       istring_from_buffer(b:tbuffer3), "-",
	       string_from_buffer(b:tbuffer4), "-",
	       string_from_buffer(b:tbuffer5));
	       
 return(_ret); 
 
}

#--------------------------------------------------------------------------#


function dce_bind()
{ 
 uuid = raw_string(0x08, 0x83, 0xAF, 0xE1,
		   0x1F, 0x5D, 0xC9, 0x11,
		   0x91, 0xA4, 0x08, 0x00,
		   0x2B, 0x14 ,0xA0, 0xFA);
		   

 transfer_syntax = raw_string(
 		   0x04, 0x5D, 0x88, 0x8A, 0xEB, 0x1C, 0xC9, 0x11,
		   0x9F, 0xE8, 0x08, 0x00, 0x2B, 0x10, 0x48, 0x60
		   );  
		   
 return(raw_string(0x05, 0x00, 0x0B, 0x03,
 		   0x10, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
		   0x01, 0x00, 0x00, 0x00, 0xD0, 0x16, 0xD0, 0x16,
		   0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x01, 0x00) 
		   + uuid
		   + raw_string(0x03, 0x00, 0x00, 0x00) 
		   + transfer_syntax +
		   raw_string(0x02, 0x00, 0x00, 0x00));
}



function dce_enum_get(callid, handle)
{
 _c = callid % 255;
 _ret  = raw_string(0x05, 0x00, 0x00, 0x03, 
 		    0x10, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		    _c,   0x00, 0x00, 0x00, 0x4C, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00) + handle + raw_string(0x01, 0x00, 0x00, 0x00);

 return(_ret);

}


function load_long(b, t)
{
 __ret_lo_lo = ord(b[t]);
 __ret_hi_lo = ord(b[t+1])*256;
 __ret_lo_hi = ord(b[t+2])*65536;
 __ret_hi_hi = ord(b[t+3])* 16777216;
 
 __ret    = __ret_hi_hi + __ret_lo_hi + __ret_hi_lo + __ret_lo_lo;
 return(__ret);
}


function load_short_ntohs(b, t)
{
 __ret_lo = ord(b[t]);
 __ret_hi = ord(b[t+1])*256;
 __ret    = __ret_hi + __ret_lo;
 return(__ret);
}

function load_short(b, t)
{
 __ret_lo = ord(b[t+1]);
 __ret_hi = ord(b[t])*256;
 __ret    = __ret_hi + __ret_lo;
 return(__ret);
}


function dce_parse(result)
{
 #
 # Update the handle
 # 
 handle = "";
 for(i=0;i<16;i=i+1)
 {
  handle = string(handle,raw_string(ord(result[28+i])));
 }
 
 
 p = 84; # 28 + 16 + 40;
 tint = load_long(b:result, t:p);
 annotation = "";
 
 p = p + 4;
 #display("tint_ann : ", tint, "\n");
 for(i=0;i<tint;i=i+1)
 {
   annotation = string(annotation, r[p+i]);
 }
 #display("=======> ", annotation, "\n");
 
 p = p + tint;
 

 while((tint % 4))
 {
  p = p + 1;
  tint = tint + 1;
 }
# p = p + 1;
# for(i=0;i<4;i=i+1)display(hex(ord(r[p+i])), " ");
# display("\n");
 realtype = load_long(b:r, t:p);
 p = p + 8;
 typefield = load_short(b:r, t:p);

 p = p + 2;
 sizefield = load_short(b:r, t:p);
 p = p + 2;
 
 guid = "";
 for(i = 0 ; i < 16 ; i = i + 1)
 {
  guid = string(guid,raw_string(r[p+i]));
 }
 
 
 p = p + 57; 			#   16+2+4+2+1+16+2+4+2+1+4+2+2;
 
 IPTYPE   = 0x4B;
 NCACN_NP  = 0x58;
 NCALRPC  = 0x47;
 NCALRPC2 = 0x56;
 NCALRPC3 = 0x4E;
 UNKNOWN1 = 0x5A;
 
 if(realtype == IPTYPE)
 {
  mytype = "     Type: ncacn_ip_";
  
  udp_or_tcp = ord(r[p]);
  if(udp_or_tcp == 0x08)proto = "udp";
  else {
   if(udp_or_tcp == 0x07)proto = "tcp";
   else proto = "unknown!";
   }
  mytype = string(mytype, proto, "\n");
  
  p = p + 3 ;   #1 + 2;
  port = load_short(b:r, t:p);
  p = p + 7;   #2 + 2 + 3;
  ip = "";
  for(i=0;i<3;i=i+1)
  {
   ip = ip + ord(r[p+i]) + ".";
  }
  ip = ip + ord(r[p+3]);
  report = string("A DCE service is listening on ", ip, ":", port, " : \n\n",
  			mytype,
			"     UUID : ", strguid(guid:guid), "\n");
  if(annotation)report = string(report, "     Annotation : ", annotation, "\n");
  myip = this_host();
  
  if(proto == "unknown!")proto = "tcp";
  
   security_note(port:port, data:report, proto:proto);
 }
 
 if((realtype == NCALRPC3) ||
    (realtype == NCALRPC2) ||
    (realtype == NCALRPC))
 {
  p = p + 1;
  strlength = load_short_ntohs(b:r, t:p);
 
  
  p = p + 2;
  servicename = "";
  for(i=0;i<strlength;i=i+1)
  {
   servicename = string(servicename, r[i+p]);
  }
  report = string("The DCE Service '", servicename, "' is running on this host\n",
		"     Type : ncalrpc\n",
  		 "     UUID : ", strguid(guid:guid), "\n");
  if(annotation)report = string(report, "     Annotation : ", annotation, "\n");		 
  security_note(port:135, data:report);
 }
 
 if(realtype == NCACN_NP)
 {
  p = p  + 1;
  sizeshort = load_short(b:r, t:p);
  p = p  + 2;
  nacn_endpoint = "";
  for(i=0;i<sizeshort;i=i+1)
  {
   nacn_endpoint = string(nacn_endpoint, r[p]);
   p = p + 1;
  }
 # display(nacn_endpoint, "\n");
 }
 #display(hex(realtype), "\n");
}


#-----------------------------------------------------------------------------------------#


handle = raw_string(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
	
if(get_port_state(135))
{	
 soc = open_sock_tcp(135);
 if(!soc)exit(0);
 
 enum = 0;

 send(socket:soc, data:dce_bind());
 r = recv(socket:soc, length:4096);
 if(strlen(r) < 60)exit(0); # bad reply length

 for(x=0;x<4096;x=x+1)
 {
 send(socket:soc, data:dce_enum_get(callid:x, handle:handle));
 #sleep(1);
 r = recv(socket:soc, length:4096);
 #display(".\n");

 if(strlen(r) <= 65)
 {
  # finished
  x = 4096;
 }
 else {
 	dce_parse(result:r);
	enum = enum + 1;
	}
 }
 close(soc);
 if(enum)security_warning(135);
}
