#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10793);
 script_version ("$Revision: 1.4 $");

 name["english"] = "Cobalt Web Administration Server Detection";
 script_name(english:name["english"]);

 desc["english"] = "
The remote web server is the Cobalt Administration web server. 

This web server enables attackers to configure your Cobalt server 
if they gain access to a valid authentication username and password.

Solution: Disable the Cobalt Administration web server if 
you do not use it, or block inbound connections to this port.

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Cobalt Web Administration Server Detection";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www", 81);
 exit(0);
}

#
# The script code starts here
#

 port = get_kb_item("Services/www");
 if (!port) port = 81;

 soc = open_sock_tcp(port);
 if(soc)
 {
  req = http_get(item:"/admin/", port:port);
  send(socket:soc, data:req);
  buf = recv(socket:soc, length:5000);

  #display(buf);
  if (("401 Authorization Required" >< buf) && (("CobaltServer" >< buf) || ("CobaltRQ" >< buf)) && ("WWW-Authenticate: Basic realm=" >< buf))
  {
   security_note(port);
  }
  close(soc);
 }

