#
# This script was written by Michel Arboi <arboi@algoriel.fr> 
#
# GPL, blah blah blah
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10919);
 script_version ("$Revision: 1.5 $");

 name["english"] = "Check open ports";
 name["francais"] = "Vrifie les ports ouverts";
 
 script_name(english:name["english"],
            francais:name["francais"]);
 
 desc["english"] = "
This plugin checks if the port scanners did not kill a service.

Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check if ports are still open";
 summary["francais"] = "Vrifie si les ports sont toujours ouverts";
 script_summary(english:summary["english"],
               francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 script_timeout(0);	# This plugin is slow

 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Misc.";
 family["francais"] = "Divers";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("find_service.nes");
 exit(0);
}

#

for (i=1; i < 65536;i=i+1)
{
 if(i == 139)i = i+1; # Ugly hack

 state = get_kb_item(string("Ports/tcp/", i));
 if (state)
 {
   s = open_sock_tcp(i);
   if (! s)
    security_warning(port:i, data:"The port was detected as opened by scanner but is now closed. The service was probably crashed by the scanner");
   else
    close(s);
 }
}
