
# This script is (C) Noam Rathaus

if (description)
{
 script_id(10779);
 script_version ("$Revision: 1.5 $");
 script_name(english:"CGIEmail's CGICso (Send CSO via CGI) Command Execution Vulnerability");
 desc["english"] = "
The remote host seems to be vulnerable to a security problem in 
CGIEmail (cgicso).  The vulnerability is caused by inadequate processing 
of queries by CGIEmail's cgicso and results in a command execution 
vulnerability.

Impact:
The server can be compromised by executing commands as the web server's 
running user (usually 'nobody').

Solution:
Modify cgicso.h to contain a strict setting of your finger host.

Example:
Define the following in cgicso.h:
#define CGI_CSO_HARDCODE
#define CGI_CSO_FINGERHOST 'localhost'

Risk factor : High

Additional information:
http://www.securiteam.com/exploits/5TP0W005FE.html";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if a remote host is vulnerable to the cgicso vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

port = get_kb_item("Services/www");
if (!port) port = 80;

dir[0] = "/bin/";
dir[1] = "/cgi-local/cgiemail-1.4/";
dir[2] = "/cgi-local/";
dir[3] = "/cgi/cgiemail/";
dir[4] = "/html/cgi-bin/";
dir[5] = "/cgi-local/cgiemail-1.6/";
dir[6] = string(cgibin(), "/");

if (get_port_state(port))
{
 for (i = 0; dir[i] ; i = i + 1)
 {
  url = string(dir[i], "cgicso");
 # display("URL: ", url, "\n");

  if (is_cgi_installed(url))
  {
   # display("CGI found at: ", url, "\n");
   data = string(url, "?query=AAA");

   req = http_get(item:data, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

    # display(buf);
    if ("400 Required field missing: fingerhost" >< buf)
    {
     security_hole(port:port);
     exit(0);
    }
    else
    {
     security_note(port:port);
     exit(0);
    }
   }
  }
 }
}
