#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10605);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CVE-2001-0010");
 
 
 name["english"] = "BIND vulnerable to overflows";
 name["francais"] = "BIND vulnerable a des overflows";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote BIND server, according to its
version number, is vulnerable to various buffer
overflows that may allow an attacker to 
gain a shell on this host.

Solution : upgrade to bind 8.2.3 or 4.9.8
Risk factor : High";


 desc["francais"] = "
D'aprs son numro de version, le serveur BIND distant
est vulnrable  plusieurs dpassements de buffer
permettant  un pirate de passer root sur ce systme.

Solution : mettez  jour BIND en 8.2.3 ou 4.9.8
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks the remote BIND version";
 summary["francais"] = "Vrifie le numro de version du BIND distant";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("bind_version.nasl");
 script_require_keys("bind/version");
 exit(0);
}

vers = get_kb_item("bind/version");
if(!vers)exit(0);
if(ereg(string:vers,
	 pattern:"8\.(([0-1].*)|(2\.[0-2])).*"))security_hole(53);

if(ereg(string:vers,
    	pattern:"4\.([0-8]|9\.[0-7]).*"))security_hole(53);

