#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# and is based on BEA_weblogic_Reveal_source_code.nasl
#
# See the Nessus Scripts License for details
#



if(description)
{

script_id(10949);
script_version("$Revision: 1.1 $");

name["english"]="BEA WebLogic Scripts Server scripts Source Disclosure (2)";
name["francais"]="BEA WebLogic rvle les sources des scripts installs sur le serveur. (2)";
script_name(english:name["english"], francais:name["francais"]);

desc["english"]="
BEA WebLogic may be tricked into revealing the source code of JSP scripts
by adding an encoded character (ie: %00x) at the end of the request.


Solution: Use the official patch available at http://www.bea.com
or upgrade to a version newer than 6.1SP2

Risk factor : Medium";
script_description(english:desc["english"]);


 

summary["english"]="BEA WebLogic may be tricked into revealing the source code of JSP scripts.";
summary["francais"]="BEA WebLogic peut etre utilis dans le but d'afficher les sources des scripts.";
script_summary(english:summary["english"], francais:summary["francais"]);




script_category(ACT_GATHER_INFO);





script_copyright(english:"This script is (C) 2002 Renaud Deraison");


family["english"]="CGI abuses";
family["francais"]="Abus de CGI";
script_family(english:family["english"], francais:family["francais"]);
 

script_dependencie("find_service.nes", "no404.nasl", "webmirror.nasl");
 
script_require_ports("Services/www", 80);

exit(0);
}


function check(req, port)
{ 
soc = open_sock_tcp(port);
if(!soc) return(0); 

request = http_get(item:req, port:port); 
send(socket:soc, data:request);
response = recv(socket:soc, length:8096);
close(soc); 


#signature of Jsp.

signature = "<%=";

if (signature >< response) return(1);
 
return(0);
}

port=get_kb_item("Services/www");
if(!port) port=80;

if(!get_port_state(port)) exit(0);

# Try with a known jsp file
file = get_kb_item(string("www/", port, "/content/extensions/jsp/1"));
if(!file)file = "/index.jsp";
if(check(req:string(file, "%00x"), port:port))security_hole(port);
 
