/*
 * nikto wrapper
 *
 * Finds bad CGI
 */

#include <includes.h>
#define NIKTO "nikto.pl"

/*
 *  Plugin functions
 */

#define EN_NAME "Nikto"
#define FR_NAME "Nikto"

#define EN_DESC "\
This plugin runs nikto(1) to find CGI.\n\
See the section 'plugins options' to configure it"

#define FR_DESC "\
Ce plugin appelle nikto(1) pour trouver les CGI.\n\
Allez voir la section 'plugins options' pour le configurer"


#define COPYRIGHT "This script is copyright (C) Michel Arboi - <arboi@algoriel.fr>"
/*Nikto is based upon whisker, by RainForestPuppy*/

#define EN_SUMMARY "Find CGI with nikto"
#define FR_SUMMARY "Trouve les CGI  l'aide de nikto"

#define EN_FAMILY "CGI abuses"
#define FR_FAMILY "Abus de CGI"


#define NIKTO_ALLCGI	"Force scan all possible CGI directories"
#define NIKTO_GENERIC	"Force full (generic) scan"
#define NIKTO_SSL	"Also test HTTPS servers"

#define NIKTO_IDS "IDS evasion technique:"
#define NIKTO_IDS_DFL "X (none);\
1 Random URI encoding (non-UTF8);\
2 Directory self-reference (/./);\
3 Premature URL ending;\
4 Prepend long random string;\
5 Fake parameter;\
6 TAB as request spacer;\
7 Random case sensitivity;\
8 Use Windows directory separator (\\);\
9 Session splicing (slow)"

PlugExport int plugin_init(desc)
     struct arglist	*desc;
{
  if(!is_shell_command_present(NIKTO))
    	return -1;
  plug_set_id(desc, 10864);
  plug_set_version(desc, "$Revision: 1.11 $");
   
  plug_set_name(desc, FR_NAME, "francais");
  plug_set_name(desc, EN_NAME, NULL);
 
  plug_set_summary(desc, FR_SUMMARY, "francais");
  plug_set_summary(desc, EN_SUMMARY, NULL);
 
  plug_set_description(desc, FR_DESC, "francais");
  plug_set_description(desc, EN_DESC, NULL);
 
  plug_set_copyright(desc, COPYRIGHT,NULL);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, FR_FAMILY, "francais");
  plug_set_family(desc, EN_FAMILY, NULL);
  plug_set_dep(desc, "find_service.nes");
  plug_set_dep(desc, "httpver.nasl");
  plug_set_dep(desc, "http_auth.nasl");
  plug_require_port(desc, "Services/www");
  plug_require_port(desc, "80");
  plug_require_port(desc, "443");
 
  /* plug_set_timeout(desc, -1); */
  add_plugin_preference(desc, NIKTO_ALLCGI, PREF_CHECKBOX, "no");
  add_plugin_preference(desc, NIKTO_GENERIC, PREF_CHECKBOX, "no");
  add_plugin_preference(desc, NIKTO_SSL, PREF_CHECKBOX, "no");
  add_plugin_preference(desc, NIKTO_IDS, PREF_RADIO, NIKTO_IDS_DFL);
  return 0;
}


PlugExport int plugin_run(desc)
     struct arglist	*desc;
{
  struct arglist * globals = arg_get_value(desc, "globals");

  struct in_addr	*ip;
  FILE	*fp = NULL;
  char	*allcgi = get_plugin_preference(desc, NIKTO_ALLCGI);
  char	*gener = get_plugin_preference(desc, NIKTO_GENERIC);
  char	**argv, s[256], *p, *rep, *repp, *nikto_dir;
  char	*port_str = plug_get_key(desc, "Services/www");
  int	cnx_encaps, port, flag, httpver;
  char	*user = plug_get_key(desc, "http/username");
  char	*pass = plug_get_key(desc, "http/password");
  char	*ids = get_plugin_preference(desc, NIKTO_IDS);
  char	*ssl_supported = get_plugin_preference(desc, NIKTO_SSL);


  if (port_str != NULL)
    port = atoi(port_str);
  else
    port = 80;

  if(host_get_port_state(desc, port) == 0)
    return 0;

  cnx_encaps =  plug_get_port_transport(desc, port);

  if (IS_ENCAPS_SSL(cnx_encaps) && strcmp(ssl_supported, "yes") != 0)
    return 0;	/* Bug in SSL support in Nikto 1.1 BETA2 */

  argv = append_argv(0, NIKTO);

  sprintf(s, "http/%d", port);
  if ((p = plug_get_key(desc, s)) != NULL && *p != '\0')
    httpver = atoi(p);
  
  p = (char*)plug_get_host_fqdn(desc);
  if (p != NULL && *p != '\0')
    {
      if (httpver > 10)
	{
	  argv = append_argv(argv, "-vhost");
	  argv = append_argv(argv, p);
	}
    }
  else
    {
      ip = plug_get_host_ip(desc);
      p = inet_ntoa(*ip);
    }
  argv = append_argv(argv, "-h");
  argv = append_argv(argv, p);

  sprintf(s, "%d", port);
  argv = append_argv(argv, "-p");
  argv = append_argv(argv, s);

  if (IS_ENCAPS_SSL(cnx_encaps))
    argv = append_argv(argv, "-ssl");
  
  if (strcmp(allcgi, "yes") == 0)
    argv = append_argv(argv, "-allcgi");
  if (strcmp(gener, "yes") == 0)
    argv = append_argv(argv, "-gener");

  if (ids != NULL && *ids != 'X')
    {
      s[0] = ids[0]; s[1] = '\0';
      argv = append_argv(argv, "-evasion");
      argv = append_argv(argv, s);
    }

  if (user != NULL && *user != '\0')
    {
      if (pass != NULL && *pass !='\0')
	sprintf(s, "%s:%s", user, pass);
      else
	strcpy(s, user);
      argv = append_argv(argv, "-id");
      argv = append_argv(argv, s);
    }

  /* 
   * If we cannot find the nikto directory or enter it, 
   * expect problems!
   */
  if ((p = find_in_path(NIKTO, 1)) != NULL && *p != '\0')
    {
      if (chdir(p) < 0)
	perror(p);
    }
  else
    fprintf(stderr, "Could not find %s in $PATH\n", NIKTO);

  fp = ptyexecvp(NIKTO, (const char**)argv, NULL);
  destroy_argv (argv);

  if (fp == NULL)
    {
      fprintf(stderr, "ptyexecvp(%s) failed\n", NIKTO);
      return 0;
    }

  /* read output */

  rep = emalloc(80);
  strcpy(rep, "Here is the nikto report:\n");
  for (repp = rep; *repp != '\0'; repp++)
    ;

  flag = 0;
  for (;;)
    {
      while ((p = fgets(s, sizeof(s) - 1, fp)) == NULL && errno == EAGAIN)
	sleep(1);
      if (p == NULL)
	break;
#if 0
      fprintf(stderr, "> %s", s);
#endif
      /*
       * There is a bug in ptyexec (I suppose) on SuSE Linux 6.4:
       * The report is polluted by useless debugging messages
       * So we take only lines that start with + - or ERROR
       */
#if 1
      if (s[0] != '+' && s[0] != '-' && strncmp(s, "ERROR", 5) != 0)
	continue;
#endif

      rep = (char*)erealloc(rep, strlen(rep) + strlen(p) + 1);
      /* rep may have changed */
      for (repp = rep; *repp != '\0'; repp++)
	;
      strcpy(repp, p);
      flag = 1;
    }
  if (flag)
    post_note(desc, port, rep);
  efree(&rep);

  fclose(fp);

  return 0;
}


