/*
 * Find service
 *
 * This plugin is released under the GPL
 */
#include <includes.h>

#define EN_NAME "Services"
#define FR_NAME "Services"

#define EN_FAMILY "Misc."
#define FR_FAMILY "Divers"

#define EN_DESC "This plugin attempts to guess which\n\
service is running on the remote ports. For instance,\n\
it searches for a web server which could listen on\n\
another port than 80 and set the results in the plugins\n\
knowledge base.\n\n\
Risk factor : None"

#define FR_DESC "Ce plugin tente de deviner quels\n\
services tournent sur quels ports.\n\
Par exemple, il cherche si un serveur\n\
web tourne sur un port autre que le 80\n\
et il stocke ses rsultats dans la\n\
base de connaissance des plugins.\n\n\
Facteur de risque : Aucun"

#define EN_COPY "Written by Renaud Deraison <deraison@cvs.nessus.org>"
#define FR_COPY "Ecrit par Renaud Deraison <deraison@cvs.nessus.org>"

#define EN_SUMM "Find what is listening on which port"
#define FR_SUMM "Dtermine ce qui coute sur quel port"


#ifdef HAVE_SSL
#define CERT_FILE "SSL certificate : "
#define KEY_FILE  "SSL private key : "
#define PEM_PASS "PEM password : "
#define CA_FILE	"CA file : "
#endif
#define CNX_TIMEOUT_PREF	"Network connection timeout : "
#define RW_TIMEOUT_PREF		"Network read/write timeout : "
/*
 * XXX
 * This plugin is highly beta and NOT complete
 *
 */
 
int plugin_init(desc)
 struct arglist * desc;
{ 
 plug_set_id(desc, 10330);
 plug_set_version(desc, "$Revision: 1.57 $");
 
 plug_set_name(desc, FR_NAME, "francais");
 plug_set_name(desc, EN_NAME, NULL);
 
 
 plug_set_category(desc, ACT_GATHER_INFO);
 
 
 plug_set_family(desc, FR_FAMILY, "francais");
 plug_set_family(desc, EN_FAMILY, NULL);
 
 plug_set_description(desc, FR_DESC, "francais");
 plug_set_description(desc, EN_DESC, NULL);
 
 plug_set_summary(desc, FR_SUMM, "francais");
 plug_set_summary(desc, EN_SUMM,NULL);
 
 plug_set_copyright(desc, FR_COPY, "francais");
 plug_set_copyright(desc, EN_COPY, NULL);
 add_plugin_preference(desc, CNX_TIMEOUT_PREF, PREF_ENTRY, "5");
 add_plugin_preference(desc, RW_TIMEOUT_PREF, PREF_ENTRY, "5");
 
 

#ifdef HAVE_SSL
 add_plugin_preference(desc, CERT_FILE, PREF_FILE, "");
 add_plugin_preference(desc, KEY_FILE, PREF_FILE, "");
 add_plugin_preference(desc, PEM_PASS, PREF_PASSWORD, "");
 add_plugin_preference(desc, CA_FILE, PREF_FILE, "");

#define TEST_SSL_PREF	"Test SSL based services"
 add_plugin_preference(desc, TEST_SSL_PREF, PREF_RADIO, "All;Known SSL ports;None");
#endif
#define QUICK_SOCKS_PREF	"Quick SOCKS proxy checking"
 add_plugin_preference(desc, QUICK_SOCKS_PREF, PREF_CHECKBOX, "yes");
 plug_set_timeout(desc, PLUGIN_TIMEOUT*4);
 return(0);
}


void mark_chargen_server(desc, port)
 struct arglist * desc;
 int port;
{
 plug_set_key(desc, "Services/chargen", ARG_INT, (void *)port);
 post_note(desc, port, "Chargen is running on this port");
}

void mark_echo_server(desc, port)
 struct arglist * desc;
 int port;
{
 plug_set_key(desc, "Services/echo", ARG_INT, (void *)port);
 post_note(desc, port, "an echo server is running on this port");
}

void mark_ncacn_http_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * ban = emalloc(255);
 if(port==593)
 {
  plug_set_key(desc, "Services/http-rpc-epmap", ARG_INT, (void *)port);
  sprintf(ban, "http-rpc-epmap/banner/%d", port);
  plug_set_key(desc, ban, ARG_STRING, buffer);
 }
 else
 {
  plug_set_key(desc, "Services/ncacn_http", ARG_INT, (void *)port);
  sprintf(ban, "ncacn_http/banner/%d", port);
  plug_set_key(desc, ban, ARG_STRING, buffer);
 }
 efree(&ban);
}

void mark_vnc_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/vnc", ARG_INT, (void *)port);
 sprintf(ban, "vnc/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 efree(&ban);
}

void mark_nntp_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/nntp", ARG_INT, (void*)port);
 sprintf(ban, "nntp/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 sprintf(ban, "a NNTP server is running on this port%s",
	     get_encaps_through(trp));
 post_note(desc, port, ban);
 efree(&ban);
}


void mark_swat_server(desc, port, buffer)
struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/swat", ARG_INT, (void*)port);
}

void mark_vqserver(desc, port, buffer)
struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/vqServer-admin", ARG_INT, (void*)port);
}




void mark_http_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
   char * ban = emalloc(255);
   plug_set_key(desc, "Services/www", ARG_INT, (void *)port);
   sprintf(ban, "www/banner/%d", port);
   plug_set_key(desc, ban, ARG_STRING, buffer);
   sprintf(ban, "a web server is running on this port%s",
	       get_encaps_through(trp));
   post_note(desc, port, ban);
   efree(&ban);
}

#if 0
static void
mark_gnutella_servent(desc, port, buffer, trp)
     struct arglist	*desc;
     int		port, trp;
     char		*buffer;
{
  char	ban[256];

  plug_set_key(desc, "Services/gnutella", ARG_INT, (void *)port);
  sprintf(ban, "www/banner/%d", port);
  plug_set_key(desc, ban, ARG_STRING, buffer);
  sprintf(ban, "a Gnutella servent is running on this port%s",
	  get_encaps_through(trp));
  post_note(desc, port, ban);
}
#endif

void mark_rmserver(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
   char * ban = emalloc(255);
   plug_set_key(desc, "Services/realserver", ARG_INT, (void *)port);
   sprintf(ban, "realserver/banner/%d", port);
   plug_set_key(desc, ban, ARG_STRING, buffer);
    
   sprintf(ban, "a RealMedia server is running on this port%s",
	     get_encaps_through(trp));
   post_note(desc, port, ban);
   efree(&ban);
}

void mark_smtp_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/smtp", ARG_INT, (void *)port);
 sprintf(ban, "smtp/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 efree(&ban);
 if(strstr(buffer, " postfix"))plug_set_key(desc, "smtp/postfix", ARG_INT,(void*) 1);
 {
  char * report = emalloc(255 + strlen(buffer));
  char *t = strchr(buffer, '\n');
  if(t)t[0]=0;
  sprintf(report, "a SMTP server is running on this port%s\n\
Here is its banner : \n%s",
	  get_encaps_through(trp), buffer);
   post_note(desc, port, report);
   efree(&report);
 }
}

void mark_ftp_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char* ban = emalloc(255);
 plug_set_key(desc, "Services/ftp", ARG_INT, (void *)port);
 sprintf(ban, "ftp/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 efree(&ban);
 {
  char * report = emalloc(255 + strlen(buffer));
  char *t = strchr(buffer, '\n');
  if(t)t[0]=0;
  sprintf(report, "a FTP server is running on this port%s.\n\
Here is its banner : \n%s",
	  get_encaps_through(trp), buffer);
   post_note(desc, port, report);
   efree(&report);
 }
}

void
mark_ssh_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/ssh", ARG_INT, (void *)port);
 while((buffer[strlen(buffer)-1]=='\n')||
       (buffer[strlen(buffer)-1]=='\r'))buffer[strlen(buffer)-1]='\0';
 sprintf(ban, "ssh/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 efree(&ban);
 post_note(desc, port, "a ssh server is running on this port");
}

void
mark_http_proxy(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char * ban = emalloc(255);
 /* the banner is in www/banner/port */
 plug_set_key(desc, "Services/http_proxy", ARG_INT, (void *)port);
 sprintf(ban, "an HTTP proxy is running on this port%s",
	 get_encaps_through(trp));
 post_note(desc, port, ban);
 efree(&ban);
}

void
mark_pop_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * c = strchr(buffer, '\n');
 char * ban = emalloc(255);
 char * buffer2;
 int i;
 if(c)c[0]=0;
 buffer2 = estrdup(buffer);
 for(i=0;i<strlen(buffer2);i++)buffer2[i] = tolower(buffer2[i]);    
 if(!strcmp(buffer2, "+ok"))
  {
  plug_set_key(desc, "Services/pop1", ARG_INT, (void *)port);
  sprintf(ban, "pop1/banner/%d", port);
  plug_set_key(desc, ban, ARG_STRING, buffer);
  }
  else if(strstr(buffer2, "pop2"))
   {
   plug_set_key(desc, "Services/pop2", ARG_INT, (void *)port);
   sprintf(ban, "pop2/banner/%d", port);
   plug_set_key(desc, ban, ARG_STRING, buffer);
   post_note(desc, port, "a pop2 server is running on this port");
   }
   else
    {
    plug_set_key(desc, "Services/pop3", ARG_INT, (void *)port);
    sprintf(ban, "pop3/banner/%d", port);
    plug_set_key(desc, ban, ARG_STRING, buffer);
    post_note(desc, port, "a pop3 server is running on this port");
    }
   efree(&ban);
   efree(&buffer2); 
}

void
mark_imap_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/imap", ARG_INT, (void *)port);
 sprintf(ban, "imap/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
   {
     sprintf(ban, "an IMAP server is running on this port%s",
	     get_encaps_through(trp));
	     post_note(desc, port, ban);
   }
 efree(&ban);
}

void
mark_auth_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/auth", ARG_INT, (void *)port);
 post_note(desc, port, "an identd server is running on this port");
}

void
mark_wild_shell(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{

 plug_set_key(desc, "Services/wild_shell", ARG_INT, (void*)port);
 
 post_hole(desc, port, "a shell seems to be running on this port ! (this is a possible backdoor)");
}

void
 mark_telnet_server(desc, port, buffer, trp)
 struct arglist * desc;
 int port, trp;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/telnet", ARG_INT, (void*)port);
   {
     sprintf(ban, "a telnet server seems to be running on this port%s",
	     get_encaps_through(trp));
     post_note(desc, port, ban);
   }
}

void
 mark_netbus_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{

 plug_set_key(desc, "Services/netbus", ARG_INT, (void*)port);
 post_hole(desc, port, "NetBus is running on this port");
}


void
mark_linuxconf(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * ban = emalloc(255);
 plug_set_key(desc, "Services/linuxconf", ARG_INT, (void *)port);
 sprintf(ban, "linuxconf/banner/%d", port);
 plug_set_key(desc, ban, ARG_STRING, buffer);
 efree(&ban);
 post_note(desc, port, "Linuxconf is running on this port");
}

static void
mark_socks_proxy(desc, port, ver, pa, authm)
     struct arglist	* desc;
     int		port, ver;
     unsigned char	*pa;
     int		authm;
{
  char			str[256], s[80], ipstr[16], *p;
  int			n;
  struct in_addr	*t = plug_get_host_ip(desc);

#ifdef DEBUG
  fprintf(stderr, "mark_socks_proxy: port=%d ver=%d authm=%d\n",
	  port, ver, authm);
#endif
  sprintf(str, "Services/socks%d", ver);
  plug_set_key(desc, str, ARG_INT, (void *)port);
  n = sprintf(str, "A SOCKS%d proxy is running on this port. ", ver);
  p = str + n;

  if (pa == NULL)
    strcpy(p, ";We could not determine its external interface address");
  else if (t == NULL || memcmp(t, pa, 4) != 0)
    {
      sprintf(ipstr, "%d.%d.%d.%d",
	      (int)pa[0], (int)pa[1], (int)pa[2], (int)pa[3]);
      sprintf(p, ";Its external interface address is %s", ipstr);
      sprintf(s, "socks%d/ext_ip/%d", ver, port);
      plug_set_key(desc, s, ARG_STRING, ipstr);
    }
  if (ver > 4 && authm != -1)
    {
      sprintf(s, "socks%d/auth/%d", ver, port);
      plug_set_key(desc, s, ARG_INT, (void*) authm);

      while (*p != '\0')
	p++;
      switch (authm)
	{
	case 0:
	  strcpy(p, ";It does not require authentication, or does not implement it.");
	  break;
	case 1:
	  strcpy(p, ";It prefers the username/password authentication.");
	  break;
	case 2:
	  strcpy(p, ";It prefers the GSS API authentication");
	  break;
	case 0xFF:
	  strcpy(p, ";It rejected all standard authentication methods (none, password, GSS API)");
	  break;
	default:
	  /* Should *not* happen: the SOCKS proxy chosed a method that we 
	   * did not propose */
	  sprintf(p, "; It prefers the 0x%x authentication method (bug?)",
		 authm);
	  break;
	}
    }

  post_note(desc, port, str);
}

static int
check_for_socks_proxy(desc, port, trp)
     struct arglist	*desc;
     int		port, trp;
{
  int		cnx, len, found = 0;
  unsigned char	buf[64];
  char		*p;
  int		authm = -1;

#ifdef DEBUG
  fprintf(stderr, "check_for_socks_proxy: port=%d\n", port);
#endif
  if ((cnx = open_stream_connection(desc, port, trp, 2)) >= 0)
    {
      /*
       * SOCKS4 request: 
       * 1	Version number (4)
       * 1	Command (1: connect / 2: bind)
       * 2	Port
       * 4	Address
       * Var	UserID
       * 1	zero (0)
       */
#if 0
      /* connect: 127.0.0.1:65535 */
#define SOCKS4_REQ "\004\001\xFF\xFF\x7F\0\0\001root\0"
#else
      /* Bind: (local) port = 65535; expected remote address = 10.10.10.10 */
#define SOCKS4_REQ "\004\002\xFF\xFF\x0A\x0A\x0A\x0Aroot\0"
#endif

      write_stream_connection(cnx, SOCKS4_REQ, sizeof(SOCKS4_REQ)-1);
      len = read_stream_connection(cnx, buf, 8);
      if (len == 8)
	{
	  /*
	   * SOCKS4 answer:
	   * 1	version (0)
	   * 1	code (90 -> 92)
	   * 2	port (or 0)
	   * 4	IP (or 0)
	   */
	  if (buf[0] == 0 && buf[1] >= 90 && buf[1] <= 93)
	    {
	      /* really looks like a SOCKS4 server */
	      if (buf[1] == 90)
		p = buf+4;
	      else
		p = NULL;
	      mark_socks_proxy(desc, port, 4, p, authm);
	      found ++;
	    }
	}
      close_stream_connection(cnx);
    }

  if ((cnx = open_stream_connection(desc, port, trp, 2)) >= 0)
    {
      /*
       * SOCKS5 connection: 
       * 1	Version number (5)
       * 1	# of auth methods 
       * Var	Array of methods:
       *	1	Method number:	0: no auth
       *				1: GSSAPI
       *				2: password 
       *				3-7F: IANA reserved,
       *				80-FE: user reserved
       *				FF: no method 
       *
       * We should announce at least GSS API to be RFC conformant.
       *
       * The server answers:
       * 1	Version
       * 1	Chosen method (or FF if failure)
       */
#if 1
# define SOCKS5_CNX "\005\003\0\1\2"
#else
# define SOCKS5_CNX "\005\001\0"
#endif
      write_stream_connection(cnx, SOCKS5_CNX, sizeof(SOCKS5_CNX)-1);
      len = read_stream_connection(cnx, buf, 2);
      if (len == 2)
	{
#if 0
	  fprintf(stderr, "Buf = %02x %02x %02x %02x\n",
		  buf[0], buf[1], buf[2], buf[3]);
#endif
	  if (buf[0] == 5 && (buf[1] <= 2 || buf[1] == 0xFF))
	    /* buf[1] >= 0 is always true! */
	    {
	      authm = buf[1];
	      /*
	       * really looks like a SOCKS5 server
	       */
#define SOCKS5_REQ "\005\002\0\001\x0A\x0A\x0A\x0A\xFF\xFF" /* bind */
	      write_stream_connection(cnx, SOCKS5_REQ, sizeof(SOCKS5_REQ)-1);
	      len = read_stream_connection(cnx, buf, 10);
	      if (buf[1] != 0 || buf[3] != 1)
		{
#if 0
		  fprintf(stderr, "Buf = %02x %02x %02x %02x\n",
			  buf[0], buf[1], buf[2], buf[3]);
#endif	  
		  p = NULL;
		}
	      else
		p = buf + 4;
	      mark_socks_proxy(desc, port, 5, p, authm);
	      found ++;
	    }
	}
      close_stream_connection(cnx);
    }

  return found;
}


static int
known_ssl_port(int port)
{
  switch(port)
    {
    case 115:			/* SFTP */
    case 261:			/* Nsiiops = IIOP name service over tls/ssl */
    case 443:			/* HTTPS */
    case 448:			/* ddm-ssl */
    case 465:			/* SMTPS */
    case 563:			/* NNTPS */
    case 585:			/* imap4-ssl (not recommended) */
    case 636:			/* LDAPS */
    case 989:			/* FTPS data */
    case 990:			/* FTPS control */
    case 992:			/* telnets */
    case 993:			/* IMAPS */
    case 994:			/* IRCS */
    case 995:			/* POP3S */
    case 1241:			/* Nessus */
      return 1;
    default:
      return 0;
    }
  /*NOTREACHED*/
}

int plugin_run(desc)
 struct arglist * desc;
{
 struct arglist * h;
 char * head = "Ports/tcp/";
 u_short unknown[65535];
 int num_unknown = 0;
 int len_head = strlen(head);
 int	might_be_socks = 0;
 int	test_ssl = 0;
 int	rw_timeout = 5, cnx_timeout = 5;
 int	x;
 char	*rw_timeout_s = get_plugin_preference(desc, RW_TIMEOUT_PREF);
 char	*cnx_timeout_s = get_plugin_preference(desc, CNX_TIMEOUT_PREF);
#ifdef HAVE_SSL
  char * key   = get_plugin_preference(desc, KEY_FILE);
  char * cert  = get_plugin_preference(desc, CERT_FILE);
  char * pempass = get_plugin_preference(desc, PEM_PASS);
  char * cafile  = get_plugin_preference(desc, CA_FILE);
  char * test_ssl_s = get_plugin_preference(desc, TEST_SSL_PREF);
  char	*quick_socks_s = get_plugin_preference(desc, QUICK_SOCKS_PREF);

  if(key && strlen(key))key = (char*)get_plugin_preference_fname(desc, key);
  else key = NULL;
  
  if(cert && strlen(cert))cert = (char*)get_plugin_preference_fname(desc, cert);
  else cert = NULL;
 
  if (cafile && strlen(cafile))cafile = (char*)get_plugin_preference_fname(desc, cafile);
  else cafile = NULL;
  
  test_ssl = 2;
  if (test_ssl_s != NULL)
    if (strcmp(test_ssl_s, "None") == 0)
      test_ssl = 0;
    else if (strcmp(test_ssl_s, "Known SSL ports") == 0)
      test_ssl = 1;

  if (quick_socks_s != NULL && strcmp(quick_socks_s, "no") == 0)
    might_be_socks = 1;

  if(key || cert)
  {
   if(!key)key = cert;
   if(!cert)cert = key;
   plug_set_ssl_cert(desc, cert);
   plug_set_ssl_key(desc, key);
  }

  if (pempass != NULL)
    plug_set_ssl_pem_password(desc, pempass);
  if (cafile != NULL)
    plug_set_ssl_CA_file(desc, cafile);
#endif /* HAVE_SSL */  
  
  if (rw_timeout_s != NULL && (x = atoi(rw_timeout_s)) > 0)
    rw_timeout = x;
  if (cnx_timeout_s != NULL && (x = atoi(cnx_timeout_s)) > 0)
    cnx_timeout = x;
 
 bzero(unknown, sizeof(unknown));

 
 h = arg_get_value(desc, "key");
 if(!h)return(1);

 /*
  * Search for a web server and stop when one is found
  */
 while(h && h->next)
 {
  if((strlen(h->name) > len_head)&&
     !strncmp(h->name, head, len_head))
  {
    int		cnx;
    char	* line;
    char 	* origline;
    int		trp, i;
    char * buffer = emalloc(2048);
    unsigned char * banner = NULL;
    int port = atoi(h->name+len_head);
    int flg = 0;
    int	unindentified_service = 0;


    if (test_ssl == 2 || 
	test_ssl == 1 && known_ssl_port(port))
      cnx = open_stream_connection_unknown_encaps(desc, port, cnx_timeout, &trp);
    else
      {
	trp = NESSUS_ENCAPS_IP;
	cnx = open_stream_connection(desc, port, trp, cnx_timeout);
      }
  
  if(cnx >= 0)
   {
    int		len;
    
#ifdef DEBUG    
    fprintf(stderr, "Port %d is open. \"Transport\" is %d\n", port, trp);
#endif    
    plug_set_port_transport(desc, port, trp);
    (void) stream_set_timeout(port, rw_timeout);

#ifdef HAVE_SSL
    if (IS_ENCAPS_SSL(trp))
      {
	char	report[160];
        sprintf(report, "A %s server answered on this port\n", 
		get_encaps_name(trp));
	post_note(desc, port, report);
	plug_set_key(desc, "Transport/SSL", ARG_INT, (void*) port);
      }
#endif
    
 
   sprintf(buffer, "GET / HTTP/1.0\r\n\r\n");
   write_stream_connection(cnx, buffer, strlen(buffer));
   bzero(buffer, 2048);
   len = read_stream_connection(cnx, buffer, 2047);
   if (len >= 0)
     {
    banner = estrdup(buffer);
   for(i=0;i<len;i++)buffer[i] = tolower(buffer[i]);      
   line = estrdup(buffer);
  
   if(strchr(line, '\n')){
   	char * t = strchr(line, '\n');
	t[0]='\0';
	}
	
   origline = estrdup(banner);
   if(strchr(origline, '\n')){
   	char * t = strchr(origline, '\n');
	t[0] = '\0';
	}
    
    /*
     * Many services run on the top of an HTTP protocol,
     * so the HTTP test is not an 'ELSE ... IF'
     */
    if(!strncmp(line, "http/1.", 7))
    {  
      flg++;
      mark_http_server(desc, port, banner, trp);
    }
   
   
    if(((u_char)buffer[0]==255) && (((u_char)buffer[1]==251) || ((u_char)buffer[1]==252) || ((u_char)buffer[1]==253) || ((u_char)buffer[1]==254)))
      mark_telnet_server(desc, port, origline, trp);
    else  if((strstr(line, "smtp") || strstr(line, "simple mail transfer")) && !strncmp(line, "220", 3))
    	mark_smtp_server(desc, port, origline, trp);	
    else if(strstr(buffer, "rmserver")||strstr(buffer, "realserver"))
        mark_rmserver(desc, port, origline, trp);
    else if(strstr(line, "ftp") && !strncmp(line, "220", 3))
    	mark_ftp_server(desc, port, origline, trp);	
    else if(strstr(line, "ssh-"))
    	mark_ssh_server(desc, port, origline);
    else if(!strncmp(line, "+ok", 3) || (!strncmp(line, "+", 1) && strstr(line, "pop")))
    	mark_pop_server(desc, port, origline);
    else if(strstr(line, "imap4") && !strncmp(line, "* ok", 4))
    	mark_imap_server(desc, port, origline, trp);
    else if(strstr(origline, " INN ") || strstr(line, "posting ok") || strstr(line, "posting allowed"))
    	mark_nntp_server(desc, port, origline, trp);	
    else if(strstr(buffer, "networking/linuxconf") || strstr(buffer, "networking/misc/linuxconf") || strstr(buffer, "server: linuxconf"))
        mark_linuxconf(desc, port, banner);
   else if(strstr(buffer, "www-authenticate: basic realm=\"swat\""))
   	mark_swat_server(desc, port, banner);
   else if(strstr(buffer, "vqserver") &&
           strstr(buffer, "www-authenticate: basic realm=/"))
	 mark_vqserver(desc,port, banner);
   else if(strstr(buffer, "get: command not found"))
   	mark_wild_shell(desc, port, origline);	
   else if(strstr(buffer, "netbus"))
   	mark_netbus_server(desc, port, origline);	
   else if(strstr(line, "0 , 0 : error : unknown-error"))
   	mark_auth_server(desc, port, origline);
    else if(!strncmp(line, "http/1.", 7) && strstr(line, "proxy")) /* my proxy "HTTP/1.1 502 Proxy Error" */
	mark_http_proxy(desc, port, banner, trp);	
    else if(!strncmp(line, "http/1.", 7) && strstr(buffer, "via: "))
	mark_http_proxy(desc, port, banner, trp);	
    else if(!strncmp(line, "http/1.", 7) && strstr(buffer, "proxy-connection: "))
	mark_http_proxy(desc, port, banner, trp);	
    else if(!strncmp(line, "http/1.", 7) &&strstr(buffer, "cache")&&
    	    strstr(line, "bad request"))
	mark_http_proxy(desc, port, banner, trp);
#if 0
    else if (strncmp(line, "http/1.", 7) == 0 && 
	     strstr(buffer, "gnutella") != NULL)
      mark_gnutella_servent(desc, port, banner, trp);
#endif
    else if(!strncmp(origline, "RFB 00", 6) && strstr(line, ".00"))
   	mark_vnc_server(desc, port, origline);
    else if(!strncmp(line, "ncacn_http/1.", 13))
   	mark_ncacn_http_server(desc, port, origline);
    else if(!strncmp(origline, "GET / HTTP/1.0", 14))
    	mark_echo_server(desc, port ,origline);	
    else if(strstr(banner, "!\"#$%&'()*+,-./") && strstr(banner, "ABCDEFGHIJ") && strstr(banner, "abcdefghij") && strstr(banner, "0123456789"))
    	mark_chargen_server(desc, port, banner);	
    else
      {
	if (banner[0] == 5 && banner[1] <= 8 && 
	    banner[2] == 0 && banner[3] <= 4
	    || 
	    banner[0] == 0 && (banner[1] >= 90 && banner[1] <= 93))
	  might_be_socks = 1;
	unindentified_service = ! flg;
      }
   efree(&line);
   efree(&origline); 
   }
   else
   {
#ifdef DEBUG
     fprintf(stderr, "Could not read anything from port %d\n", port);
#endif
     unindentified_service = 1;
   }
   close_stream_connection(cnx);
   efree(&buffer);

   if (might_be_socks && unindentified_service && 
       check_for_socks_proxy(desc, port, trp) > 0)
       unindentified_service = 0;

   if (unindentified_service && port != 139)
     /* port 139 can't be marked as 'unknown' */
    {
      char	ban[256];
      unknown[num_unknown++] = port;
      sprintf(ban, "unknown/banner/%d", port);
      plug_set_key(desc, ban, ARG_STRING, banner);
    }
   efree(&banner); 
   }
#ifdef DEBUG   
  else
    fprintf(stderr, "Could not connect to port %d\n", port);
#endif   

  }
  if(h)h = h->next;
  }
    
    
  if(num_unknown)
   {
    int i = 0;
    while(unknown[i])
      {
      plug_set_key(desc, "Services/unknown", ARG_INT,(void*)((int)unknown[i]));
      i++;
      }
   } 
 return(0);
}
