/* Nessus Attack Scripting Language
 *
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "../include/config.h"
#include <includes.h>
#include <nasl_raw.h>
#include <nessus/libnessus.h>
#if !defined(_CYGWIN_) && !defined(SYSTEM_PCAP)
#include <nessus/pcap.h>
#else
#include <pcap.h>
#endif
#include "nasl_memory.h"

#ifdef _CYGWIN_
extern unsigned short * SChar2WChar(char *);
extern char * WChar2SChar(unsigned short *);
#endif

#ifdef PCAP_RESTART
extern void PCAP_RESTART(void*);
#endif
extern int islocalhost(struct in_addr *);
pcap_t * init_ip_pcap(harglst*, struct in_addr src, struct in_addr dst,
		       char *);







pcap_t * 
open_pcap(globals, iface, filter)
 harglst * globals;
 char * iface;
 char * filter;
{
  static char errbuf[PCAP_ERRBUF_SIZE];
  int bpf;
  pcap_t * ret;
  bpf_u_int32 netmask, network;
  struct bpf_program * filter_prog = nasl_malloc(globals, sizeof(*filter_prog));
  
  bpf = wait_for_free_bpf(60); 
  if(bpf < 0)
  {
    fprintf(stderr, "nasl:pcap.c : No free bpf\n");
    ret = NULL;
   }
   else
   {
     release_bpf(bpf);
     if(!iface || !strlen(iface))
     	iface = pcap_lookupdev(errbuf);
     
     ret = pcap_open_live(iface, 1500, 0, 100, errbuf);
     if(!ret)
     	fprintf(stderr, "pcap_open_live() failed : %s\n", errbuf);
     else
     {
#ifdef PCAP_RESTART
     PCAP_RESTART(NULL);
#endif
    if(pcap_lookupnet(iface, &network, &netmask, 0)<0)
    	return(NULL);	
    if(pcap_compile(ret, filter_prog, filter, 0, netmask)<0)
    	return(NULL);
    if(pcap_setfilter(ret, filter_prog)<0)
    	return(NULL);
     }
   }   
 nasl_free(globals,filter_prog);
 return ret;
}


/*
 * Set up the pcap filter, and select the correct interface.
 *
 * The filter will be changed only if this is necessary
 * 
 */
 
pcap_t *
init_ip_pcap(globals, src, dst, filter)
 harglst * globals;
 struct in_addr src, dst;
 char * filter;
{
 static char errbuf[PCAP_ERRBUF_SIZE];
 pcap_t * ret = NULL;
 char * interface = NULL;
 char * a_dst, *a_src;
 
 a_src = nasl_strdup(globals, inet_ntoa(src));
 a_dst = nasl_strdup(globals, inet_ntoa(dst));
 if((!filter) || (filter[0]=='\0') || (filter[0]=='0'))
 {
  filter = nasl_malloc(globals, 1024);
  if(!islocalhost(&src))
  	sprintf(filter, "ip and (src host %s and dst host %s)",
 		  a_src, a_dst);
#ifdef DEBUG
printf("src : %s\n", a_src);
printf("localh : %d\n", islocalhost(&src));
#endif
		  
 }
 else {
 	if(!islocalhost(&src))filter = nasl_strdup(globals, filter);
	else filter = nasl_malloc(globals, 1);
 	}
 
 nasl_free(globals, a_dst);
 nasl_free(globals, a_src);

#ifndef _CYGWIN_
 if((interface = routethrough(&src, &dst))||
    (interface = pcap_lookupdev(errbuf)))
#else
  if(interface = pcap_lookupdev(errbuf))
#endif    
    ret = open_pcap(globals, interface, filter);
     
 if(!ret){
  	printf("ERROR : Could not find/open the pcap for interface %s\n", interface);
	return(NULL);
	}

 nasl_free(globals, filter);
 nasl_free(globals, errbuf);
 return(ret);
}


#if 0
void 
nasl_duplicate_pcaps(globals)
 struct arglist * globals;
{
 struct arglist * pcaps = arg_get_value(globals, "pcaps");
 
 while(pcaps && pcaps->next)
 {
  pcap_t * pcap = (pcap_t*)pcaps->value;
  pcap_t * new_pcap = pcap_duplicate(pcap);
  pcaps->value = (void*)new_pcap;
  pcaps = pcaps->next;
 }
}
#endif
struct ip * 
recv_ip_packet(globals, pcap, timeout)
 harglst * globals;
 pcap_t * pcap;
 int timeout;
{
  struct pcap_pkthdr head;
  int dl_len = get_datalink_size(pcap_datalink(pcap));
  char * packet = NULL;
  char * ret = NULL;
  struct timeval past, now;
  struct timezone tz;
 
  bzero(&past, sizeof(past));
  bzero(&now, sizeof(now));
  gettimeofday(&past, &tz);
  for(;;)
  {
   packet = (char*)pcap_next(pcap, &head);
   if(packet)break;
   gettimeofday(&now, &tz);
   if((now.tv_sec - past.tv_sec)>=timeout)break;
  }
  
  if(packet)
  {
   struct ip * ip;
   ip = (struct ip *)(packet + dl_len);
#ifdef BSD_BYTE_ORDERING
   ip->ip_len = ntohs(ip->ip_len);
   ip->ip_off = ntohs(ip->ip_off);
#endif   
   ip->ip_id = ntohs(ip->ip_id);
   ret = nasl_malloc(globals, UNFIX(ip->ip_len));
   memcpy(ret, ip, UNFIX(ip->ip_len));
  }
 return((struct ip*)ret);
}
