#!/usr/bin/env python

# Rnmap server v. 0.5 Beta
#
# Copyright (C) 2000,2001 Tuomo Makinen (tmakinen@pp.htv.fi)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""
Rnmap server v. 0.5 Beta

Copyright (C) 2000,2001 Tuomo Makinen
Redistributable under the terms of the GNU General Public License

Usage:
    -p: port
    -n: Nmap path
    -h: hostname

    --help          - prints this message
    --version       - show version of rnmap server
    --nofilter      - turns filtering rules off
    --noplain       - refuse plaintext connections
"""

from socket import *
import os
import string
import sys
import md5
import threading
import time
import getopt
import signal
import base64

sys.path[:0] = ['../lib']
from sec import *

CRLF = "\r\n"

PLAINTXTCON   = "100:"
CIPHERTXTCON  = "101:"
RSAKEYREQ     = "102:"
SENDRSAKEY    = "103:"
SUCCESFUL     = "201:" # Succesful
AUTHDENI      = "401:Access denied"
SCANFAIL      = "402:Operation failed"
UNKNOWNERROR  = "403:Unknown command"
BADCHARS      = "404:Operation denied"
UNSUPPORTED   = "405:No encryption support"
NOPLAINTEXT   = "406:Plaintext connection refused"
TOOWEAK       = "407:Too weak encryption key"

# NOTHESECHARS is tuple which has characters that can cause
# unwanted action, and we don't want pass them to system.
NOTHESECHARS = ("|",
                ";",
                "<",
                ">",
                "&")
                     
Server = ''
Port = 3500
Nmapl = "/usr/bin/nmap"
Filteruse = 1
Banplain = 0

# Default RSA key length, change this if you need.
Rsakeylength = 1024

try:
    opts, args = getopt.getopt(sys.argv[1:], 'p:n:h:', ['help', 'nofilter', 'version', 'noplain'])
except:
    sys.stderr.write("Try 'rnmap_server.py --help' for more information.\n")
    sys.exit()

for o, a in opts:
    if o == '-h': Server = a
    if o == '-p': Port = string.atoi(a)
    if o == '-n': Nmapl = a
    if o == '--help':
        print __doc__
        sys.exit()
    if o == '--version':
        print "Rnmap server v. 0.5 Beta"
        sys.exit()
    if o == '--nofilter':
        Filteruse = None
        Fmethod = None
    if o == '--noplain':
        Banplain = 1

if Use_cipher == 0 and Banplain == 1:
    sys.stderr.write("server has no encryption support - server startup failed.\n")
    sys.exit()
        
#==========================================================================
# read configuration files ...
#==========================================================================
# filter.conf is optional file, if omitted we're not using filtering rules.

def confreader():
    global Filteruse
    if Filteruse == 1:
        global Fmethod
        try:
            # Try to open filtering configuration
            fp = open("filter.conf")
            tmplist = fp.readlines()
            fp.close()
            global Clist
            Clist = []
            for i in xrange(len(tmplist)):
                if "#" in tmplist[i]:
                    continue
                elif tmplist[i][0:] == '\012':
                    continue
                elif tmplist[i][0] == "!":
                    Fmethod = tmplist[i][9:16]
                else:
                    Clist.append(tmplist[i])
            for j in xrange(len(Clist)):
                Clist[j] = Clist[j][:-1]
        except:
            # No filtering rules used
            Filteruse = None
            Fmethod = None
    # userlist file
    try:
        fp = open("users.list")
        ul = fp.readlines()
        global Userlist
        Userlist = {}
        for i in xrange(len(ul)):
            stopsign = 0
            for j in xrange(len(ul[i])): 
                if ul[i][0] == "#":
                    continue
                elif ul[i][0] == " ":
                    continue
                elif ul[i][j] == ":" and j != 1:
                    if stopsign == 0:
                        Userlist[ul[i][:j]] = base64.decodestring(ul[i][j+1:])
                        stopsign = 1
    except:
        logwriter("ulist_failed")
        sys.stderr.write("error reading users.list - server startup failed.\n")
        os.unlink("rnmapd.pid")
        sys.exit()
            
#==========================================================================

def waitconnection():
    s = socket(AF_INET, SOCK_STREAM)
    s.bind((Server, Port))
    s.listen(1)
    while 1:
        try:
            conn, addr = s.accept()
            data = conn.recv(4096)
        except error:
            pass
        else:
            t = threading.Thread(group=None, target=newconnection, args=(conn, data, addr[0]))
            t.start()
            
def newconnection(conn, data, host):
    if Filteruse != None:
        check = filter(host)
        if check == 0:
            message = AUTHDENI
            logwriter("banned_host", host)
        elif check != 0:
            message = message_check(data, host)
    else:
        message = message_check(data, host)
    conn.send(message)
    conn.close()
    sys.exit()

def message_check(message, host):
    if message[:4] == PLAINTXTCON and Banplain == 1:
        logwriter("no_plain", host)
        info = NOPLAINTEXT
    elif Use_cipher == 0 and message[:4] in (CIPHERTXTCON, RSAKEYREQ):
        logwriter("no_cipher", host)
        info = UNSUPPORTED
    elif message[:4] == RSAKEYREQ and Use_cipher == 1:
        info = send_pubkey(message, host)
    else:
        info = get_message_data(message, host)
    return info
                            
def get_message_data(message, host):
    com_mode = 0
    key = None
    if Use_cipher == 1 and message[:4] == CIPHERTXTCON:
        com_mode = 1
        iv = message[-8:]
        akey_start = string.find(message, ":: ", 4)
        akey = message[akey_start+3:-8]
        try:
            key = RSA_key.decrypt(akey)
        except:
            message = ''
        else:
            key = key[5:]
            if len(key) < 16:
                return TOOWEAK
            else:
                message = decipher(message[4:akey_start], key, iv)
                if message == None: message = ''
    elif message[:4] == PLAINTXTCON:
        message = message[4:]
    info = process_message(message, host, com_mode, key)
    return info

def process_message(message, host, com_mode, key):
    message = cleaner(message)
    usr_point = string.find(message, ":")
    login = message[:usr_point]
    cmd_point = string.rfind(message, ":")
    cmd = message[cmd_point+1:]
    passwd = md5.new(message[usr_point+1:cmd_point]).digest()
    if com_mode == 1:
        logwriter("secure_connection", host)
    elif com_mode == 0:
        logwriter("plain_connection", host)
    if (cmd_point != -1 and usr_point != -1) and (cmd_point != usr_point):
        auth = authenticate(login, passwd)
        if auth == "true":
            scanstat = None
            for i in xrange(len(cmd)): # Check chars 
                if cmd[i] in NOTHESECHARS:
                    scanstat = 0
                    break
                else:
                    scanstat = 1
            if scanstat == 0:
                logwriter("illegal_parameters", host, login, cmd)
                info = BADCHARS   
            elif scanstat == 1:
                info = scanner(login, host, cmd)
            else:
                info = SCANFAIL
        elif auth == "false":
            logwriter("bad_password", host, login)
            info = AUTHDENI
        elif auth == "nouser":
            logwriter("unknown_user", host, login)
            info = AUTHDENI
    else:
        info = UNKNOWNERROR
    if Use_cipher == 1 and com_mode == 1 and key != None:
            iv = key_generator(8)
            info = encipher(info, key, iv)
            info = info + iv
    return info

def scanner(login, host, cmd):
    scn = os.popen(Nmapl + " " + cmd + " - 2>/dev/null").read()
    if scn != '':
        logwriter("succesful_scan", host, login, cmd)
        info = SUCCESFUL + scn
    else:
        logwriter("failed_scan", host, login, cmd)
        info = SCANFAIL
    return info

def authenticate(login, passwd):
    if Userlist.has_key(login):
        if Userlist[login] == passwd:
            authentication = "true"
        else:
            authentication = "false"
    else:
        authentication = "nouser"
    return (authentication)

def send_pubkey(message, host):
    message = cleaner(message)
    if Userlist.has_key(message[4:]):
        fp = open("rnmap_public.key")
        public_key = fp.read()
        sharedsec = Userlist[message[4:]]
        iv = key_generator(8)
        info = encipher(SENDRSAKEY + public_key, sharedsec, iv)
        info = info + iv
        logwriter("asymk_request", host, message[4:])
    else:
        info = AUTHDENI
    return info

def logwriter(information, host=None, login=None, cmd=None):
    thread_pid = os.getpid()
    if information == "secure_connection":
        wlog = "[" + time.ctime(time.time()) + "][%d] encrypted connection from %s\n"\
               % (thread_pid, host)
    elif information == "plain_connection":
        wlog = "[" + time.ctime(time.time()) + "][%d] plaintext connection from %s\n"\
               % (thread_pid, host)
    elif information == "succesful_scan":
        wlog = "[" + time.ctime(time.time()) + "][%d] user %s from %s peformed scan: %s\n"\
               % (thread_pid, login, host, cmd)
    elif information ==  "bad_password":
        wlog = "[" + time.ctime(time.time()) + "][%d] user %s from %s tried to connect with wrong password.\n"\
               % (thread_pid, login, host)
    elif information == "asymk_request":
        wlog = "[" + time.ctime(time.time()) + "][%d] user %s from host %s requested public key.\n"\
               % (thread_pid, login, host)
    elif information == "no_plain":
        wlog = "[" + time.ctime(time.time()) + "][%d] host %s connected with unsupported plaintext mode.\n"\
               % (thread_pid, host)
    elif information == "no_cipher":
        wlog = "[" + time.ctime(time.time()) + "][%d] host %s connected with unsupported ciphertext mode.\n"\
               % (thread_pid, host)
    elif information == "unknown_user":
        wlog = "[" + time.ctime(time.time()) + "][%d] unknown user %s from %s tried to connect.\n"\
               % (thread_pid, login, host)
    elif information == "failed_scan":
        wlog = "[" + time.ctime(time.time()) + "][%d] user %s from %s peformed failed scan: %s\n"\
               % (thread_pid, login, host, cmd)
    elif information == "banned_host":
        wlog = "[" + time.ctime(time.time()) + "][%d] banned host: %s dropped.\n"\
               % (thread_pid, host)
    elif information ==  "illegal_parameters":
        wlog = "[" + time.ctime(time.time()) + "][%d] user %s from %s used illegal parameters: %s\n"\
               % (thread_pid, login, host, cmd)
    elif information == "startup":
        if Use_cipher == 0:
            wlog = "[" + time.ctime(time.time()) + "][%d] rnmap server started.\n"\
                   % (thread_pid)
        elif Use_cipher == 1:
            wlog = "[" + time.ctime(time.time()) + "][%d] rnmap server started with encryption support.\n"\
                   % (thread_pid)
    elif information == "sigterm":
        wlog = "[" + time.ctime(time.time()) + "][%d] received the SIGTERM signal.\n"\
               % (thread_pid)
    elif information == "sighup":
        wlog = "[" + time.ctime(time.time()) + "][%d] received the SIGHUP signal.\n"\
               % (thread_pid)
    elif information == "ulist_failed":
        wlog = "[" + time.ctime(time.time()) + "][%d] error reading users.list - server startup failed.\n"\
               % (thread_pid)
    elif information == "keylist_failed":
        wlog = "[" + time.ctime(time.time()) + "][%d] error reading rnmap_user.keys.\n"\
               % (thread_pid)
    elif information == "pubkey_failed":
        wlog = "[" + time.ctime(time.time()) + "][%d] error reading RSA keys - server startup failed.\n"\
               % (thread_pid)
    #---    
    try:
        fp = open("rnmap_server.log", "a")
        fp.write(wlog)
        fp.close()
    except IOError:
        wlog = "rnmap_server: " + time.ctime(time.time()) + " Can't write to disk!\n"
        sys.stderr.write(wlog)
        
def cleaner(message):
    if len(message) >= 2:
        if message[-2:] == CRLF:
            message = message[:-2]
        elif message[-1:] in CRLF:
            message = message[:-1]
    return message

def filter(host):
    check = None
    hcheck = host
    if Fmethod == "drpexcp":
        if hcheck in Clist:
            check = 1
        else:
            check = 0
    if Fmethod == "allexcp":
        if hcheck in Clist:
            check = 0
        else:
            check = 1
    return check

def signal_handler(signum, frame):
    if signum == 1:
        logwriter("sighup")
        confreader()
    elif signum == 15:
        logwriter("sigterm")
        os.unlink("rnmapd.pid")
        sys.exit()

# Set default umask
os.umask(0066)

logwriter("startup")

if Use_cipher == 1:
    import pubkey
    RSA_key, Publickey, pubkey_stat = pubkey.pub_keys(Rsakeylength)

    if pubkey_stat == 0:
        logwriter("pubkey_failed")
        sys.exit()
        
# Set signal traps
signal.signal(signal.SIGTERM, signal_handler)
signal.signal(signal.SIGHUP, signal_handler)

# Fork to background ...
pid = os.fork()
if pid != 0:
    sys.exit()
else:
    run = os.getpid()
    fp = open("rnmapd.pid", "w")
    fp.write(`run` + "\012")
    fp.close()
    confreader()
    waitconnection()
