#!/usr/bin/env python

# Rnmap adduser v. 0.1
#
# Copyright (C) 2001 Tuomo Makinen (tmakinen@pp.htv.fi)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import os
import sys
import md5
import base64
import string

def main():
    uname = get_name()
    hp = get_passwd()
    check_user(uname)
    write_userinfo(uname, hp)
    restart()

def restart():
    try:
        pid = open("rnmapd.pid").read()
        pid = string.atoi(pid)
    except IOError:
        pass
    else:
        print "\nSending HUP signal to rnmapd."
        os.kill(pid, 1)
    print "\nAll done."
    sys.exit()

def get_name():
    while 1:
        uname = raw_input("Username: ")
        if uname == "":
            sys.stderr.write("Username can't be empty.\n")
        else:
            return uname

def get_passwd():
    hide(1)
    try:
        while 1:
            passwd = raw_input("Password: "); sys.stdout.write("\n")
            if passwd == "":
                sys.stderr.write("Password can't be empty.\n")
            else:
                passwd2 = raw_input("Retype password: ")
                if passwd != passwd2:
                    sys.stderr.write("\nPasswords do not match.\n")
                else:
                    hide(0)
                    hp = base64.encodestring(md5.new(passwd).digest())
                    return hp
    except:
        hide(0)
        
def check_user(uname):
    try:
        fp = open("users.list").readlines()
    except IOError:
        pass
    else:
        for i in xrange(len(fp)):
            scolon = string.find(fp[i], ":")
            luname = fp[i][:scolon]
            if uname == luname:
                sys.stderr.write("\nUser " + uname + " already exists.\n")
                sys.exit()

def write_userinfo(uname, hp):
    fp = open("users.list", "a")
    fp.write(uname + ":" + hp)
    fp.close()

def hide(value):
    if value == 1:
        os.system("stty -echo")
    else:
        os.system("stty echo")
    
os.umask(0066)
main()
