# Copyright (C) 2001 Tuomo Makinen (tmakinen@pp.htv.fi)
# Licensed under the terms of the GNU General Public License

try:
    from Crypto.Cipher import Blowfish
except ImportError:
    Use_cipher = 0
else:
    Use_cipher = 1
    
def encipher(plaintext, key, iv):
    cipherblock = 8
    cipher = Blowfish.new(key, Blowfish.CBC, iv)
    if len(plaintext) % cipherblock != 0:
        fullsize = (len(plaintext)/cipherblock+1) * cipherblock
        padding = fullsize - len(plaintext)
        plaintext = plaintext + padding * "\0"
    ciphertext = cipher.encrypt(plaintext)
    return ciphertext

def decipher(ciphertext, key, iv):
    cipherblock = 8
    if len(ciphertext) % cipherblock != 0:
        plaintext = None  # Just refuse incorrect block length
    else:
        cipher = Blowfish.new(key, Blowfish.CBC, iv)
        plaintext = cipher.decrypt(ciphertext)
        i = len(plaintext)-1
        while i >= 0:
            if plaintext[i] != "\0":
                plaintext = plaintext[:i+1]
                break
            i = i - 1
    return plaintext

def key_generator(size):
    key = open("/dev/urandom").read(size)
    return key
