# Copyright (C) 2001 Tuomo Makinen (tmakinen@pp.htv.fi)
# Licensed under the terms of the GNU General Public License

from sec import key_generator
import cPickle
import sys

def pub_keys(keylength):
    pubkey_stat = 1
    try:
        fp_1 = open("rnmap_private.key")
        fp_2 = open("rnmap_public.key")
    except IOError:
        from Crypto.PublicKey import RSA
        sys.stdout.write("Generating RSA keys ...")
        sys.stdout.flush()
        RSA_key = RSA.generate(keylength, key_generator)
        Publickey = RSA_key.publickey()
        fp_1 = open("rnmap_private.key", "w")
        fp_2 = open("rnmap_public.key", "w")
        p_1 = cPickle.Pickler(fp_1)
        p_1.dump(RSA_key)
        fp_1.close()
        p_2 = cPickle.Pickler(fp_2)
        p_2.dump(Publickey)
        fp_2.close()
        sys.stdout.write("\n")
    else:
        try:
            u_1 = cPickle.Unpickler(fp_1)
            RSA_key = u_1.load()
            u_2 = cPickle.Unpickler(fp_2)
            Publickey = u_2.load()
            fp_1.close(); fp_2.close()
        except:
            sys.stdout.write("Error reading RSA keys!\a\n")
            pubkey_stat = 0
            
    return RSA_key, Publickey, pubkey_stat
