# Copyright (C) 2001 Tuomo Makinen (tmakinen@pp.htv.fi)
# Licensed under the terms of the GNU General Public License

import os
import string
import cPickle
import md5
from sec import key_generator, encipher, decipher

Perror = "Protocol error"
Keyreq = "102:"
Statusheaders = ("103",
                 "201",
                 "401",
                 "402",
                 "403",
                 "404",
                 "405",
                 "406",
                 "407")

def save_key(key, server):
    try:
        fp = open(os.environ["HOME"] + "/.rnmap.keys", "a")
    except IOError:
        pass
    else:
        fp.write(server+": " + key + "\n###\n") 
        fp.close()

def fetch_key(server):
    publickey = None
    try:
        fp = open(os.environ["HOME"] + "/.rnmap.keys")
    except IOError:
        pass
    else:
        keyfile = fp.read()
        key_start = string.find(keyfile, server)
        key_stop = string.find(keyfile, "###", key_start)
        if key_start != -1:
            publickey = keyfile[key_start + len(server) + 2:key_stop-1]
            publickey = cPickle.loads(publickey)
    return publickey
            
def generate_message(logid, passwd, publickey, payload):
    key = key_generator(16)
    iv = key_generator(8)
    ciphered = encipher(logid + ":" + passwd + ":" + payload, key, iv)
    ciphered_key = publickey.encrypt("key: " + key, '')
    message = "101:" + ciphered + ":: " + ciphered_key[0] + iv
    return message, key

def get_pubkey(passwd, message):
    iv = message[-8:]
    sharedsec = md5.new(passwd).digest()
    spkey = decipher(message[:-8], sharedsec, iv)
    return spkey
