#!/usr/bin/env python

# Rnmap console client v. 0.1.3
#
# Copyright (C) 2000,2001 Tuomo Makinen (tmakinen@pp.htv.fi)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""Usage:
    -s: Rnmap server address
    -p: Port (default 3500)
    -f: Filename to save the scanning result (no stdout)
    -n: Nmap command

    --plain         - Use plaintext communications
    --help          - prints this message
    --mparseable    - use machine parseable log form
    --scriptkiddie  - use script kiddie log form
    --xml           - use xml log form

    example:
    # rnmap.py -s 192.168.1.78 -n "-sS -p 1-65535 192.168.1.10" --mparseable"""

from socket import *
import sys
import os
import string
import getopt
import termios, TERMIOS

sys.path[:0] = ['../lib']

from client import *
from sec import *
if Use_cipher == 1:
    import cPickle

Port = 3500
Mode = " -oN"
File = None
Server = None
Nmapcmd = ""
Crypt = 1

try:
    opts, args = getopt.getopt(sys.argv[1:], 's:p:n:f:', ['help', 'version', 'mparseable', 'scriptkiddie', 'xml', 'plain'])
except:
    sys.stderr.write("Try 'rnmap.py --help' for more information.\n")
    sys.exit()

for o, a in opts:
    if o == '-s': Server = a
    if o == '-p': Port = string.atoi(a)
    if o == '-n': Nmapcmd = a
    if o == '-f': File = a
    if o == '--plain': Crypt = 0
    if o == '--mparseable': Mode = " -oM"
    elif o == '--scriptkiddie': Mode = " -oS"
    elif o == '--xml': Mode = " -oX"
    if o == '--help':
        print __doc__
        sys.exit()

if Server == None:
    print __doc__
    sys.exit()

if Use_cipher == 0 and Crypt == 1:
    sys.stderr.write("Can't find cryptographic modules!\n")
    sys.stderr.write("Use --plain command line option to force plaintext communications mode if you know what you are doing.\n")
    sys.exit()

def connection(packet):
    s = socket(AF_INET, SOCK_STREAM)
    try:
        s.connect((Server, Port))
    except error:
        sys.stderr.write("\nConnection refused\n")
        sys.exit()
    s.send(packet)
    data = ''
    while 1:
        read = s.recv(4096)
        if not read:
            break
        data = data + read    
    s.close()
    return data

def invalid_key():
    sys.stderr.write("Invalid server key\n")
    sys.exit()
    
def main():
    logid = raw_input("Username for " + Server + ": ")   
    fd = sys.stdin.fileno()
    old = termios.tcgetattr(fd)
    new = termios.tcgetattr(fd)
    new[3] = new[3] & ~TERMIOS.ECHO
    try:
        termios.tcsetattr(fd, TERMIOS.TCSADRAIN, new)
        passwd = raw_input("Password: ")
    finally:
        termios.tcsetattr(fd, TERMIOS.TCSADRAIN, old)

    sys.stdout.write("\n")

    if Crypt == 1:
        publickey = fetch_key(Server)
        if publickey == None:
            message = Keyreq + logid
        else:
            message, key = generate_message(logid, passwd, publickey, Nmapcmd + Mode)
    else:
        message = "100:" + logid + ":" + passwd + ":" + Nmapcmd + Mode
        
    result = connection(message)

    if Crypt == 1 and publickey  == None and result[:3] != "405":
        spkey = get_pubkey(passwd, result)
        try:
            publickey = cPickle.loads(spkey[4:])
        except:
            invalid_key()
        else:
            save_key(spkey[4:], Server)
            message, key = generate_message(logid, passwd, publickey, Nmapcmd + Mode)
            result = connection(message)
    if Crypt == 1 and result[:3] not in ("401", "405", "407"):
        iv = result[-8:]
        result = decipher(result[:-8], key, iv)
    if result == None or result[:3] not in Statusheaders:
        sys.stdout.write(Perror + "\n")
        sys.exit()
    else:
        if File == None:
            sys.stdout.write(result[4:])
            if result[:3] != "201":
                sys.stdout.write("\n")
        else:
            try:
                fp = open(File, "w")
                fp.write(result[4:])
                fp.close()
            except IOError:
                sys.stderr.write("\nCan't write to disk!\n")
            else:
                sys.stdout.write("\n")

os.umask(0066)
main()
