#!/usr/bin/env python

# GUI Rnmap client v. 0.5 Beta
#
# Copyright (C) 2000,2001 Tuomo Makinen (tmakinen@pp.htv.fi)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""
Rnmap server GUI client v. 0.5 Beta
"""

from socket import *
from Tkinter import *
import sys
import string
import os

sys.path[:0] = ['../lib']

from client import *
from sec import *
if Use_cipher == 1:
    import cPickle

# read configuration file ...
try:
    if os.name == "posix":
	    fp = open(os.environ["HOME"]+"/.grnmap.conf")
    else:
	    fp = open("grnmap.conf")
    res = fp.readlines()
    fp.close()
    for ol in xrange(len(res)):
	for il in xrange(len(res[ol])):
	    if res[ol][0] == "#":
		continue
	    elif res[ol][0] == " ":
		continue
	    elif res[ol][il] == ":":
		if res[ol][:il] == "server":
		    Server = res[ol][2+il:-1]
		elif res[ol][:il] == "port":
		    port = res[ol][2+il:-1]
		    port = string.atoi(port)
					
except:
    # Using defaults
    Server = "127.0.0.1"
    port = 3500
	
def CoreSocket(sendit):
    s = socket(AF_INET, SOCK_STREAM)
    try:
        s.connect((Server, port))
    except error:
        gui.ssaid.set("Can't connect to remote host")
    else:
        s.send(sendit)
        data = ''
        while 1:
            read = s.recv(4096)
            if not read:
                break
            data = data + read
        s.close()
        return data

class Rgui:
    def __init__(self, master):
	if os.name != "posix":
	    self.font_1 = None
	else:
	    self.font_1 = "Helvetica 12"
	data 		= None
	self.select	= IntVar()
	self.sIvar 	= IntVar()
	self.sUvar 	= IntVar()
	self.nPvar 	= IntVar()
	self.oSvar 	= IntVar()
	self.vBose 	= IntVar()
	self.sRvar	= IntVar()
	self.fragIP	= IntVar()
	self.fastscan	= IntVar()
	self.srcbutton	= IntVar()
	self.portbutton	= IntVar()
	self.guruknow 	= IntVar()
	self.decoybtn	= IntVar()
	self.slctbounce	= IntVar()
	self.keep_pass  = IntVar()
	self.ssaid 	= StringVar()
	self.servername = StringVar()
	self.null  	= StringVar()
	self.ports 	= StringVar()
	self.scanfile	= StringVar()
	self.hostlist	= StringVar()
	self.sourceport = StringVar()
	self.servername.set(Server+":"+`port`)
	self.scanfile.set("results.scan")
	self.select.set(1)
	self.ssaid.set("Welcome to Remote NMAP")
				
	for text, row, column, fg, sticky in [("Host(s) to scan:", 1, 0, None, W), ("Login ID:", 2, 0, None, W), ("Password:", 3, 0, None, W), \
                                              ("Server:", 4, 0, None, W), ("Scan options:", 1, 2, "darkblue", W), ("General scan options:", 6, 0, "darkblue", W)]:
	    Label(master, text=text, font=self.font_1, fg=fg).grid(row=row, column=column, sticky=sticky)
		
	self.mbar 	= Frame(master, relief=GROOVE, width=470, height=30, borderwidth=2).grid(row=0, columnspan=3)
	self.logid      = Entry(master, width = 16, bg="white")
	self.secret     = Entry(master, width = 16, bg="white", show="*", textvariable=self.null)
	self.hosts	= Entry(master, width = 20, bg="white", textvariable=self.hostlist)
    	self.server	= Entry(master, width = 16, bg="white", textvariable=self.servername)
	self.sC 	= Radiobutton(master, text="connect()    ", font=self.font_1, variable=self.select, value=1, command=self.disablefragdecoy)
    	self.sS		= Radiobutton(master, text="SYN scan     ", font=self.font_1, variable=self.select, value=2)
    	self.sN		= Radiobutton(master, text="NULL scan    ", font=self.font_1, variable=self.select, value=3)
    	self.sF		= Radiobutton(master, text="FIN scan     ", font=self.font_1, variable=self.select, value=4)
    	self.sX		= Radiobutton(master, text="XMAS scan    ", font=self.font_1, variable=self.select, value=5)
    	self.sA		= Radiobutton(master, text="ACK scan     ", font=self.font_1, variable=self.select, value=6)
    	self.sW		= Radiobutton(master, text="Window scan  ", font=self.font_1, variable=self.select, value=7)
	self.sP 	= Radiobutton(master, text="Ping scan    ", font=self.font_1, variable=self.select, value=8, command=self.disableudpbounce)
	self.srcbtn	= Checkbutton(master, text="Source port: ", font=self.font_1, variable=self.srcbutton)
    	self.src	= Entry(master, width = 13, bg="white", textvariable=self.sourceport)
	self.bouncebtn	= Checkbutton(master, text="Bounce scan: ", font=self.font_1, variable=self.slctbounce, command=self.checkbounceudpstat)
	self.bouncebox	= Entry(master, width = 13, bg="white")
    	self.oS 	= Checkbutton(master, text="OS Detect    ", font=self.font_1, variable=self.oSvar)
	self.nP 	= Checkbutton(master, text="Don't ping   ", font=self.font_1, variable=self.nPvar)
	self.vB 	= Checkbutton(master, text="Verbose      ", font=self.font_1, variable=self.vBose)
	self.sI 	= Checkbutton(master, text="Ident scan   ", font=self.font_1, variable=self.sIvar)
	self.sU 	= Checkbutton(master, text="UDP scan     ", font=self.font_1, variable=self.sUvar, command=self.checkbounceudpstat)
	self.guru	= Checkbutton(master, text="User options:", font=self.font_1, variable=self.guruknow)
	self.guruwrite	= Entry(master, width=13, bg="white")
	self.sR		= Checkbutton(master, text="RPC scan     ", font=self.font_1, variable=self.sRvar)
	self.frag	= Checkbutton(master, text="Fragment IP  ", font=self.font_1, variable=self.fragIP, command=self.checkfragstat)
	self.Fast	= Checkbutton(master, text="Fast scan    ", font=self.font_1, variable=self.fastscan, command=lambda : gui.portbutton.set(0))
	self.ports	= Checkbutton(master, text="Port range   ", font=self.font_1, variable=self.portbutton, command=lambda : gui.fastscan.set(0))
	self.prange	= Entry(master, width = 13, bg="white")
	self.usedecoys	= Checkbutton(master, text="Use Decoys:  ", font=self.font_1, variable=self.decoybtn, command=self.checkdecoystat)
	self.decoys	= Entry(master, width = 13, bg="white")
        self.scan	= Button(master, width=3, text="Scan", font=self.font_1, command=self.execute)
	self.quit 	= Button(master, width=3, text="Exit", font=self.font_1, command=lambda : sys.exit())
	self.passrememb = Checkbutton(master, text="Remember password", font=self.font_1, variable=self.keep_pass, command=self.disable_passwd)
	
	if os.name != "posix":
	    self.text = Text(master, height=18, width=75, bg="white")
	else:
	    self.text = Text(master, height=18, width=65, bg="white")
	self.scroll 	= Scrollbar(master, command=self.text.yview)
	self.message    = Message(master, font=self.font_1, fg = "blue", width=200, textvariable=self.ssaid)		
	self.text.configure(yscrollcommand=self.scroll.set)
	self.logid.grid(row=2, column=1, sticky=W)
	self.secret.grid(row=3, column=1, sticky=W)
	self.hosts.grid(row=1, column=1, sticky=W)
	self.server.grid(row=4, column=1, sticky=W)
	self.sC.grid(row=2, sticky=W, column=2)
	self.sS.grid(row=3, sticky=W, column=2)
	self.sN.grid(row=4, sticky=W, column=2)
	self.sF.grid(row=5, sticky=W, column=2)
	self.sX.grid(row=6, sticky=W, column=2)
	self.sA.grid(row=7, sticky=W, column=2)
	self.sW.grid(row=8, sticky=W, column=2)
	self.sP.grid(row=9, sticky=W, column=2)
	self.srcbtn.grid(row=10, sticky=W, column=2)
	self.src.grid(row=11, sticky=W, column=2)
	self.bouncebtn.grid(row=12, sticky=W, column=2)
	self.bouncebox.grid(row=13, sticky=W, column=2)
	self.oS.grid(row=7, sticky=W, column=0)
    	self.nP.grid(row=8, sticky=W, column=0)
	self.vB.grid(row=9, sticky=W, column=0)
    	self.sI.grid(row=10, sticky=W, column=0)
    	self.sU.grid(row=11, sticky=W, column=0)
    	self.guru.grid(row=12, sticky=W, column=0)
	self.guruwrite.grid(row=13, sticky=W, column=0)
    	self.sR.grid(row=7, sticky=W, column=1)
	self.frag.grid(row=8, sticky=W, column=1)
    	self.Fast.grid(row=9, sticky=W, column=1)
	self.ports.grid(row=10, sticky=W, column=1)
	self.prange.grid(row=11, sticky=W, column=1)
    	self.usedecoys.grid(row=12, sticky=W, column=1)
	self.decoys.grid(row=13, sticky=W, column=1)
	self.scan.grid(row=5, column=0, sticky=W)
    	self.quit.grid(row=5, column=0)
    	self.passrememb.grid(row=5, column=1, sticky=W)
    	self.message.grid(row=14, columnspan=3, sticky=W)
	self.text.grid(row=15, column=0, columnspan=4, sticky=W)
    	self.scroll.grid(row=15, sticky=E, column=2, ipady=100)
	self.filemenu	= self.filecommand()
    	self.logmenu	= self.logcommand()
    	self.securitymenu = self.encryption()
	self.helpmenu	= self.helpcommand()
		
    def filecommand(self):
	self.filemenu = Menubutton(self.mbar, text="File", font=self.font_1, underline=0)
    	self.filemenu.grid(row=0, sticky=W)
	self.filemenu.menu = Menu(self.filemenu)
    	self.filemenu.menu.add_command(label="Save result", font=self.font_1, underline=0, command=self.savefile)
	self.filemenu.menu.add_command(label="Open result", font=self.font_1, underline=0, command=self.openfile)
    	self.filemenu.menu.add_command(label="Import hostlist", font=self.font_1, underline=0, command=self.loadlist)
	self.filemenu.menu.add("separator")
    	self.filemenu.menu.add_command(label="Exit", font=self.font_1, underline=1, command=lambda : sys.exit())
	self.filemenu["menu"] = self.filemenu.menu
    	return self.filemenu

    def logcommand(self):
	self.logparam = IntVar()
    	self.logparam.set(1)
	self.logmenu = Menubutton(self.mbar, text = "Log", font=self.font_1, underline=0)
    	self.logmenu.grid(row=0, column=0, sticky=E)
	self.logmenu.menu = Menu(self.logmenu)
    	self.logmenu.menu.add_radiobutton(label="Human readable", font=self.font_1, underline=0, variable=self.logparam, value=1)
	self.logmenu.menu.add_radiobutton(label="Machine parseable", font=self.font_1, underline=0, variable=self.logparam, value=2)
	self.logmenu.menu.add_radiobutton(label="XML output", font=self.font_1, underline=0, variable=self.logparam, value=4)
	self.logmenu.menu.add_radiobutton(label="Script kiddie", font=self.font_1, underline=0, variable=self.logparam, value=3)
    	self.logmenu["menu"] = self.logmenu.menu
	return self.logmenu

    def encryption(self):
        self.secparam = IntVar()
        if Use_cipher == 1:
            self.secparam.set(1)   
        self.securitymenu = Menubutton(self.mbar, text="Security", font=self.font_1, underline=0)
        self.securitymenu.grid(row=0, column=0)
        self.securitymenu.menu = Menu(self.securitymenu)
        if Use_cipher == 1:
            self.securitymenu.menu.add_radiobutton(label="Encryption", font=self.font_1, underline=0, variable=self.secparam, value=1)
        else:
            self.securitymenu.menu.add_radiobutton(label="Encryption", font=self.font_1, state = DISABLED, underline=0, variable=self.secparam, value=1)
            self.secparam.set(2)
        self.securitymenu.menu.add_radiobutton(label="Plaintext", font=self.font_1, underline=0, variable=self.secparam, value=2)
        self.securitymenu["menu"] = self.securitymenu.menu
        return self.securitymenu
        
    def helpcommand(self):
	self.helpmenu = Menubutton(self.mbar, text="Help", font=self.font_1, underline=0)
	self.helpmenu.grid(row=0, column=2, sticky=E)
	self.helpmenu.menu = Menu(self.helpmenu)
	self.helpmenu.menu.add_command(label="Help", font=self.font_1, underline=0, command=self.helpbox)
	self.helpmenu.menu.add_command(label="About", font=self.font_1, underline=0, command=self.aboutbox)
	self.helpmenu["menu"] = self.helpmenu.menu
	return self.helpmenu

    def helpbox(self):
	self.help = Toplevel()
	Message(self.help, width=300, text="There is no help available yet.", font=self.font_1, bg="white").grid()
        Button(self.help, text="Close", font=self.font_1, command=lambda : gui.help.destroy()).grid(row=2, sticky=N)
        
    def aboutbox(self):
	self.about = Toplevel()
	Message(self.about, width=300, text="RNMAP Version 0.5 Beta\nAuthor: Tuomo Makinen\nE-mail: tmakinen@pp.htv.fi", font=self.font_1, bg="white").grid()	
	Button(self.about, text="Close", font=self.font_1, command=lambda : gui.about.destroy()).grid(row=2, sticky=N)

    def savefile(self):
	self.savewidget = Toplevel()
    	Label(self.savewidget, text="Filename to save:", font=self.font_1).grid(row=0, sticky=W)
	self.fsname = Entry(self.savewidget, width=25, bg="white", textvariable=self.scanfile)
    	self.fsname.grid(row=1, sticky=W)
	Button(self.savewidget, text="Ok", font=self.font_1, command=self.save).grid(row=2, sticky=N)
		
    def openfile(self):
	self.openwidget = Toplevel()
    	Label(self.openwidget, text="Result file to load:", font=self.font_1).grid(row=0, sticky=W)
	self.foname = Entry(self.openwidget, width=25, bg="white")
    	self.foname.grid(row=1, sticky=W)
	Button(self.openwidget, text="Ok", font=self.font_1, command=self.load).grid(row=2, sticky=N)

    def loadlist(self):
	self.openlist = Toplevel()
    	Label(self.openlist, text="Hostlist name:", font=self.font_1).grid(row=0, sticky=W)
	self.llist = Entry(self.openlist, width=25, bg="white")
    	self.llist.grid(row=1, sticky=W)
	Button(self.openlist, text="Ok", font=self.font_1, command=self.imprtlist).grid(row=2, sticky=N)
	
    def login(self):
    	global Server, port
    	sp = self.server.get()
    	j = 0
    	for i in sp:
    	    if i == ":":
    		Server = sp[:j]
    		j = j +1
    		port = sp[j:]
    		port = string.atoi(port)
    	    j = j +1
			
    	self.my_login = self.logid.get()
	self.my_passwd = self.secret.get()
	if self.keep_pass.get() == 0:
            self.null.set("")
	# Generate new configuration file
    	self.confgenerate(Server, port)

    def confgenerate(self, Server, port):
	if os.name == "posix":
	    fp = open(os.environ["HOME"]+"/.grnmap.conf", "w")
	else:
	    fp = open("grnmap.conf", "w")    
	confstatus = "# Rnmap client configuration file\n\nport: " + `port` + "\n" + "server: " + Server + "\n"
        try:
	    fp.write(confstatus)
	    fp.close()
	except IOError:
            # Can't write to disk... oh well...
	    sys.stderr.write("Can't write to disk!\n")
	    fp.close()
			
    def execute(self, rec=None):
        if rec == None:
            self.login()
        else:
            rec = None
	my_packet = ''

    	if self.select.get() == 1:
	    my_packet = my_packet + "-sT "
	elif self.select.get() == 2:
	    my_packet = my_packet + "-sS "
	elif self.select.get() == 3:
	    my_packet = my_packet + "-sN "
	elif self.select.get() == 4:
	    my_packet = my_packet + "-sF "
	elif self.select.get() == 5:
	    my_packet = my_packet + "-sX "
	elif self.select.get() == 6:
	    my_packet = my_packet + "-sA "
	elif self.select.get() == 7:
	    my_packet = my_packet + "-sW "
	elif self.select.get() == 8:
	    my_packet = my_packet + "-sP "
	if self.sIvar.get() == 1:
	    my_packet = my_packet + "-I "
	if self.sUvar.get() == 1:
	    my_packet = my_packet + "-sU "
	if self.nPvar.get() == 1:
	    my_packet = my_packet + "-P0 "
	if self.oSvar.get() == 1:
	    my_packet = my_packet + "-O "
	if self.vBose.get() == 1:
	    my_packet = my_packet + "-v "
	if self.sRvar.get() == 1:
	    my_packet = my_packet + "-sR "
	if self.fragIP.get() == 1:
	    my_packet = my_packet + "-f "
	if self.fastscan.get() == 1:
	    my_packet = my_packet + "-F "
	if self.logparam.get() == 1:
	    self.logformat = " -oN"
	elif self.logparam.get() == 2:
	    self.logformat = " -oM"
	elif self.logparam.get() == 3:
            self.logformat = " -oS"
        elif self.logparam.get() == 4:
            self.logformat = " -oX"
	if self.guruknow.get() == 1:
	    my_packet = my_packet + (self.guruwrite.get()+" ")
	if self.slctbounce.get() == 1:
	    my_packet = my_packet + ("-b "+self.bouncebox.get()+" ")
	if self.decoybtn.get() == 1:
	    my_packet = my_packet + ("-D "+self.decoys.get()+" ")
	if self.srcbutton.get() == 1:
	    my_packet = my_packet + ("-g "+self.sourceport.get()+" ")
	if self.select.get() == 8 or self.portbutton.get() == 0:
	    pass
	else:
	    my_packet = my_packet + ("-p "+self.prange.get()+" ")

	my_packet = my_packet + (self.hosts.get())

	if self.secparam.get() == 1:
            my_pubkey = fetch_key(Server)
            if my_pubkey == None:
                my_packet = Keyreq + self.my_login
            else:
                my_packet, key = generate_message(self.my_login, self.my_passwd, my_pubkey, my_packet + self.logformat)
                
        elif self.secparam.get() == 2:  
            my_packet = "100:" + self.my_login + ":" + self.my_passwd + ":" + my_packet + self.logformat

	self.result = CoreSocket(my_packet)
	
	if self.result != None:
            if self.secparam.get() == 1 and self.result[:4] not in ("405:", "401:", "407:"):
                if Use_cipher == 1 and my_pubkey != None:
                    iv = self.result[-8:]
                    self.result = decipher(self.result[:-8], key, iv)
                elif Use_cipher == 1 and my_pubkey == None:
                    spkey = get_pubkey(self.my_passwd, self.result)
                    try:
                       my_pubkey = cPickle.loads(spkey[4:]) 
                    except:
                        self.ssaid.set("Invalid server key")
                        return
                    else:
                        save_key(spkey[4:], Server)
                        self.execute(rec = 1)
            if rec == None:        
                self.analyze(self.result)
			
    def analyze(self, data):
	# Check status code
	if data == None or data[:3] not in Statusheaders:
            self.ssaid.set(Perror)
        else:
            if data[:3] != "201":
                self.ssaid.set(data[4:])
            elif data[:3] == "201":
                gui.text.delete(1.0, END)
                gui.text.insert(END, data[4:])
                self.ssaid.set("Scan completed")
                self.res = data
			
    def save(self):
	try:
	    var = self.fsname.get()
	    fp = open(var, "a")
	    fp.write(self.res)
	    fp.close()
	    self.ssaid.set("Results saved")
	except AttributeError:
	    self.ssaid.set("No results to save yet")
	except IOError:
            self.ssaid.set("Can't write to disk!")
        self.savewidget.destroy()

    def load(self):
        try:
	    var = self.foname.get()
	    fp = open(var, "r")
	    res = fp.read()
	    gui.text.delete(1.0, END)
	    gui.text.insert(END, res)
	    self.ssaid.set("Result loaded")
	except IOError:
	    self.ssaid.set("Can't open file")
        self.openwidget.destroy()

    def imprtlist(self):
        try:
	    var = self.llist.get()
	    fp = open(var, "r")
	    scanlist = fp.read()
	    scanlist = string.replace(scanlist, "\012", "")
	    self.hostlist.set(scanlist)
	except IOError:
	    self.ssaid.set("Can't import list")
	self.openlist.destroy()

    def disable_passwd(self):
        if self.keep_pass.get() == 0:
            self.null.set("")
            
    def disablefragdecoy(self):
	self.fragIP.set(0)
	self.decoybtn.set(0)

    def disableudpbounce(self):
	self.sUvar.set(0)
	self.slctbounce.set(0)

    def checkfragstat(self):
	if self.select.get() == 1:
	    self.fragIP.set(0)
			
    def checkdecoystat(self):
	if self.select.get() == 1:
	    self.decoybtn.set(0)
	elif self.decoybtn.get() == 1 and self.slctbounce.get() == 1:
	    self.slctbounce.set(0)
		
    def checkbounceudpstat(self):
	if self.select.get() == 8:
	    self.slctbounce.set(0)
	    self.sUvar.set(0)			
	elif self.slctbounce.get() == 1 and self.decoybtn.get() == 1:
	    self.decoybtn.set(0)

os.umask(0066)
			
root = Tk()
gui = Rgui(root)

root.resizable(0, 0)
root.title("Remote NMAP client")
root.iconname("Rnmap client")
	
root.mainloop()
