/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : interface.h
 * Project : WifiScanner (c) 2002 Herv<E9> Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __interface_h__
#define __interface_h__

/* Size of Windows */
#define COL_WND_TITLE COLS
#define ROW_WND_TITLE 2

#define COL_WND_SUM 24
#define ROW_WND_SUM 20

#define COL_WND_PANEL (COL_WND_TITLE - COL_WND_SUM)
#define ROW_WND_PANEL ROW_WND_SUM

#define COL_WND_REALTIME COL_WND_TITLE
#define ROW_WND_REALTIME (LINES - ROW_WND_TITLE - ROW_WND_SUM)

#define COL_MINI_NEEDED 132
#define ROW_MINI_NEEDED 50

/* public functions */
void InitScreen (UINT8 CheckScreenSize);
void RefreshAllWND (void);
void WriteSummary (void);
void RefreshRealTime_WND (UINT8 GotItOne);
#ifdef WITH_THREAD
void RefreshRealTime_WND_th (void);
#endif

void EndCurses (void);

#endif
