/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : $Name:  $
 * Project : WifiScanner (c) 2002 Herv<E9> Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __HOSTAP_H__
#define __HOSTAP_H__

#include <wlan/p80211types.h>
#include <wlan/p80211msg.h>
#include <wlan/p80211meta.h>
#include <wlan/p80211metamsg.h>
#include <wlan/p80211metastruct.h>
#include <wlan/p80211mgmt.h>


int selectChannelHOSTAP (char *devname, int channel);
int shutCardHOSTAP (char *devname);
int openCardHOSTAP (char *devname);
int getPacketHOSTAP (unsigned char *buf, int maxlen);
int openPacketHOSTAP (char *devname);
void closePacketHOSTAP (void);

#endif
