/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : functions.h
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: functions.h,v 1.8 2003/07/04 13:00:41 poggij Exp $
 */

#ifndef __functions_h__
#define __functions_h__

#include <wlan/p80211types.h>
#include <wlan/p80211msg.h>
#include <wlan/p80211meta.h>
#include <wlan/p80211metamsg.h>
#include <wlan/p80211metastruct.h>
#include <wlan/p80211mgmt.h>

#define CHANNEL_MIN 1
#define CHANNEL_MAX 14

#define HOP_MIN 1
#define HOP_MAX 13

#define IFACE_WLAN_MIN 0
#define IFACE_WLAN_MAX 4

int processPacket (unsigned char *packet, int len);
void ParseCommandLine (int argc, char **argv,
		       UINT8 * SingleChannel, char **OutFileName,
		       char **OutDumpFileName, char **OutDotFileName,
		       UINT8 * DebugLevel,
		       unsigned int *TimeToSleepBeforeChangeChannel,
		       char *devname, UINT8 * ChannelHop,
		       UINT32 * MaxPacket, UINT8 * DateFormat,
		       UINT8 * DisplayCTRL, UINT8 * ISD_is_ON,
		       UINT8 * CheckScreenSize, UINT8 * TypeOfCard);
void ChannelToStr (char *strChannel, UINT8 Channel, UINT8 SChannel);
#endif
