/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : driver.c
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: driver.c,v 1.5 2003/07/25 11:23:08 poggij Exp $
 */

#include <include.h>
#include <src/interface.h>
#include <src/crt_io.h>
#include <src/driver.h>
#include <src/wlan-ng.h>	// Abstraction layer of Wlan-NG
#include <src/cisco.h>		// Abstraction layer of cisco
#include <src/hostap.h>		// Abstraction layer of cisco


extern unsigned int DebugLevel;
extern WINDOW *Sum_WND, *RealTime_WND;
extern ScanResult_t Res;
extern UINT8 TypeOfCard;
#ifdef WITH_THREAD
extern pthread_mutex_t screen_mutex;
#endif

p80211_caphdr_t wlan_header;

/*
 * Function to determine what is the next channel to scan
 *  and select it
 */
int
NextChannel (char *devname, unsigned int NumberOfHop)
{
  const UINT8 ListChannel[13][14] = {
    {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14},	/* 1 */
    {1, 3, 5, 7, 9, 11, 13, 14, 2, 4, 6, 8, 10, 12},	/* 2 */
    {1, 4, 7, 10, 13, 2, 5, 8, 11, 14, 3, 6, 9, 12},	/* 3 */
    {1, 5, 9, 13, 3, 7, 11, 2, 6, 10, 14, 4, 8, 12},	/* 4 */
    {1, 6, 11, 2, 7, 12, 3, 8, 13, 4, 9, 14, 5, 10},	/* 5 */
    {1, 7, 13, 5, 11, 3, 9, 2, 8, 14, 6, 12, 4, 10},	/* 6 */
    {1, 8, 2, 9, 3, 10, 4, 11, 5, 12, 6, 13, 7, 14},	/* 7 */
    {1, 7, 13, 5, 11, 3, 9, 2, 8, 14, 6, 12, 4, 10},	/* 8 */
    {1, 6, 11, 2, 7, 12, 3, 8, 13, 4, 9, 14, 5, 10},	/* 9 */
    {1, 5, 9, 13, 3, 7, 11, 2, 6, 10, 14, 4, 8, 12},	/* 10 */
    {1, 4, 7, 10, 13, 2, 5, 8, 11, 14, 3, 6, 9, 12},	/* 11 */
    {1, 3, 5, 7, 9, 11, 13, 14, 2, 4, 6, 8, 10, 12},	/* 12 */
    {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14},	/* 13 */

  };
  static UINT8 ChannelIndex = 0;
  int channel;

  if (NumberOfHop <= 7)
    channel = ListChannel[NumberOfHop - 1][ChannelIndex];
  else
    channel = ListChannel[NumberOfHop - 1][13 - ChannelIndex];

  ChannelIndex++;
  ChannelIndex = ChannelIndex % 14;

  debug (3, "selectChannel (%s,%d)\n", devname, channel);
  return selectChannel (devname, channel);
}

/*
 * Configure the card to listen in promiscuous mode on desired channel
 */
#ifdef HAVE_LIBNCURSES
const UINT8 Posit[15] = { 0, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14 };
const char *Indic[15] =
  { "", "^-.", "-^-.", ".-^-.", ".-^-.", ".-^-.", ".-^-.", ".-^-.", ".-^-.",
  ".-^-.", ".-^-.", ".-^-.", ".-^-.", ".-^-.", ".-^"
};

void
PrintScaleChannel (int channel)
{
#ifdef WITH_THREAD
  pthread_mutex_lock (&screen_mutex);
#endif
  mvwprintw (Sum_WND, 13, 2, "|_____________  _|");
  mvwprintw (Sum_WND, 13, 2 + Posit[channel], (char *) Indic[channel]);
  //mvwprintw (Sum_WND, 10, 20, "%02d", channel);
  //debug (2, "%02d\n", channel);
  wrefresh (Sum_WND);
#ifdef WITH_THREAD
  pthread_mutex_unlock (&screen_mutex);
#endif
}
#else
#define PrintScaleChannel(x)
#endif

int
selectChannel (char *devname, int channel)
// It's a wrapper
{
  int ret = FALSE;

  PrintScaleChannel (channel);
  Res.SChannel = channel;

  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
    case WLAN_NG_CARD_AVS_CFF2:
      ret = selectChannelWLAN (devname, channel);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      // Nothink to do :-)
      //  Its donne by hardware
      ret = TRUE;
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      ret = selectChannelHOSTAP (devname, channel);
      break;
    case PCAP_VIRTUAL_CARD:
      // Nothink to do :-)
      //  it's a file !
      ret = TRUE;
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
  return ret;
}

int
shutCard (char *devname)
{
  int ret = FALSE;

  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
    case WLAN_NG_CARD_AVS_CFF2:
      ret = shutCardWLAN (devname);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      ret = shutCardCISCO (devname);
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      ret = shutCardHOSTAP (devname);
      break;
    case PCAP_VIRTUAL_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
  return ret;
}

int
openCard (char *devname)
{
  int ret = FALSE;

  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
    case WLAN_NG_CARD_AVS_CFF2:
      ret = openCardWLAN (devname);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      ret = openCardCISCO (devname);
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      ret = openCardHOSTAP (devname);
      break;
    case PCAP_VIRTUAL_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
  return ret;
}


/*
 * Open the NETLINK Device
 */
int
openPacket (char *devname)
{
  int ret = 0;
  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
      ret = openPacketWLAN (devname);
      break;
    case WLAN_NG_CARD_AVS_CFF2:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      ret = openPacketCISCO (devname);
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      ret = openPacketHOSTAP (devname);
      break;
    case PCAP_VIRTUAL_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
  return ret;
}

/*
 * Just a wrapper....
 */
void
closePacket (void)
{
  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
      closePacketWLAN ();
      break;
    case WLAN_NG_CARD_AVS_CFF2:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      closePacketCISCO ();
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      closePacketHOSTAP ();
      break;
    case PCAP_VIRTUAL_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
}

// I's only a wrapper :-)
int
getPacket (unsigned char *buf, int maxlen, unsigned int timeout)
{
  int ret = 0;
  switch (TypeOfCard)
    {
    case WLAN_NG_CARD:
      ret = getPacketWLAN (buf, maxlen);
      break;
    case WLAN_NG_CARD_AVS_CFF2:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case CISCO_CARD:
    case CISCO_CVS_CARD:
      ret = getPacketCISCO (buf, maxlen);
      break;
    case LUCENT_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    case HOSTAP_CARD:
      ret = getPacketHOSTAP (buf, maxlen);
      break;
    case PCAP_VIRTUAL_CARD:
      perror ("Type of packet is not yet analysed");
      exit (EXIT_FAILURE);
      break;
    default:
      perror ("Arrrrggg, type of packet is unknowned !!!");
      exit (EXIT_FAILURE);
      break;
    }
  return ret;
}
