/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : conversion.c
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: conversion.c,v 1.9 2003/07/25 11:23:08 poggij Exp $
 */

#include <include.h>

extern UINT8 TypeOfCard;

/*
 * Function to convert a type to an another
 */

const char *
RateToString (int rate)
{
  switch (rate)
    {
    case 0:
      return "0Mb/s";
    case 2:
    case 10:
      return "1Mb/s";
    case 4:
    case 20:
      return "2Mb/s";
    case 11:
    case 55:
      return "5.5Mb/s";
    case 12:
    case 60:
      return "6Mb/s";
    case 18:
    case 90:
      return "9Mb/s";
    case 22:
    case 110:
      return "11Mb/s";
    case 24:
    case 120:
      return "12Mb/s";
    case 36:
    case 180:
      return "18Mb/s";
    case 44:
    case 220:
      return "22Mb/s";
    case 48:
    case 240:
      return "24Mb/s";
    case 66:
    case 330:
      return "33Mb/s";
    case 72:
    case 360:
      return "36Mb/s";
    case 88:
    case 440:
      return "44Mb/s";
    case 96:
    case 480:
      return "48Mb/s";
    case 108:
    case 540:
      return "54Mb/s";
    default:
      return "???";
    }
}

char *
TypeOfClientToString (int TypeOfClient)
{
  static const char *TypeOfClientList[16] = {
    TYPE_BIT_00, TYPE_BIT_01, TYPE_BIT_02, TYPE_BIT_03,
    TYPE_BIT_04, TYPE_BIT_05, TYPE_BIT_06, TYPE_BIT_07,
    TYPE_BIT_08, TYPE_BIT_09, TYPE_BIT_0A, TYPE_BIT_0B,
    TYPE_BIT_0C, TYPE_BIT_0D, TYPE_BIT_0E, TYPE_BIT_0F
  };

  return ((char *) TypeOfClientList[(TypeOfClient & 0x0F)]);
}

char *
SubTypeOfClientToString (int TypeOfClient)
{
  const char *SubTypeOfClientList[16] = {
    SUBTYPE_BIT_00, SUBTYPE_BIT_01, SUBTYPE_BIT_02, SUBTYPE_BIT_03,
    SUBTYPE_BIT_04, SUBTYPE_BIT_05, SUBTYPE_BIT_06, SUBTYPE_BIT_07,
    SUBTYPE_BIT_08, SUBTYPE_BIT_09, SUBTYPE_BIT_0A, SUBTYPE_BIT_0B,
    SUBTYPE_BIT_0C, SUBTYPE_BIT_0D, SUBTYPE_BIT_0E, SUBTYPE_BIT_0F
  };

  return ((char *) SubTypeOfClientList[((TypeOfClient & 0xF0) >> 4)]);
}

char *
BoolToStr (int Boolean)
{
  const char *YesNo[2] = { STR_NO, STR_YES };

  Boolean = !(!Boolean);
  return ((char *) YesNo[Boolean]);
}

char *
BoolToWepNoWep (int Boolean)
{
  const char *WepNoWep[2] = { STR_NOWEP, STR_WEP };

  Boolean = !(!Boolean);
  return ((char *) WepNoWep[Boolean]);
}

char *
BoolToStaAp (int Boolean)
{
  const char *StaAp[2] = { STR_STA, STR_AP };

  Boolean = !(!Boolean);
  return ((char *) StaAp[Boolean]);
}

const char *
TypeOfPacketToString (UINT16 TypeOfPacket)
{
  switch (WLAN_GET_FC_FTYPE (TypeOfPacket))
    {
      /* Frame subtypes */
    case WLAN_FTYPE_MGMT:
      /* Management */
      switch (WLAN_GET_FC_FSTYPE (TypeOfPacket))
	{
	case WLAN_FSTYPE_ASSOCREQ:
	  return ("ASSREQ");
	  break;
	case WLAN_FSTYPE_ASSOCRESP:
	  return ("ASSRES");
	  break;
	case WLAN_FSTYPE_REASSOCREQ:
	  return ("REASSQ");
	  break;
	case WLAN_FSTYPE_REASSOCRESP:
	  return ("REASSS");
	  break;
	case WLAN_FSTYPE_PROBEREQ:
	  return ("PRBREQ");
	  break;
	case WLAN_FSTYPE_PROBERESP:
	  return ("PRBRES");
	  break;
	case WLAN_FSTYPE_BEACON:
	  return ("BEACON");
	  break;
	case WLAN_FSTYPE_ATIM:
	  return ("ATIM");
	  break;
	case WLAN_FSTYPE_DISASSOC:
	  return ("DESASS");
	  break;
	case WLAN_FSTYPE_AUTHEN:
	  return ("AUTHEN");
	  break;
	case WLAN_FSTYPE_DEAUTHEN:
	  return ("DEAUTH");
	  break;
	default:
	  return ("UNKNOW");
	}
      break;
    case WLAN_FTYPE_CTL:
      switch (WLAN_GET_FC_FSTYPE (TypeOfPacket))
	{
	  /* Control */
	case WLAN_FSTYPE_PSPOLL:
	  return ("PSPOLL");
	  break;
	case WLAN_FSTYPE_RTS:
	  return ("RTS");
	  break;
	case WLAN_FSTYPE_CTS:
	  return ("CTS");
	  break;
	case WLAN_FSTYPE_ACK:
	  return ("ACK");
	  break;
	case WLAN_FSTYPE_CFEND:
	  return ("CFEND");
	  break;
	case WLAN_FSTYPE_CFENDCFACK:
	  return ("CFEACK");
	  break;
	default:
	  return ("UNKNOW");
	}
      break;
    case WLAN_FTYPE_DATA:
      switch (WLAN_GET_FC_FSTYPE (TypeOfPacket))
	{
	  /* Data */
	case WLAN_FSTYPE_DATAONLY:
	  return ("DATA");
	  break;
	case WLAN_FSTYPE_DATA_CFACK:
	  return ("DATACK");
	  break;
	case WLAN_FSTYPE_DATA_CFPOLL:
	  return ("DATPOL");
	  break;
	case WLAN_FSTYPE_DATA_CFACK_CFPOLL:
	  return ("DTPLAK");
	  break;
	case WLAN_FSTYPE_NULL:
	  return ("NULL");
	  break;
	case WLAN_FSTYPE_CFACK:
	  return ("CFACK");
	  break;
	case WLAN_FSTYPE_CFPOLL:
	  return ("CFPOL");
	  break;
	case WLAN_FSTYPE_CFACK_CFPOLL:
	  return ("CFPLAK");
	  break;
	default:
	  return ("UNKNOW");
	}
      break;
    default:
      return ("UNKNOW");
    }
}
