/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : $Name:  $
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: cisco.c,v 1.3 2003/07/25 11:23:08 poggij Exp $
 */


// A lot of think is get from kismet
//  http://www.kismetwireless.net/

#include <include.h>
#include <src/cisco.h>
#include <src/crt_io.h>

static char *ID = "$Id: cisco.c,v 1.3 2003/07/25 11:23:08 poggij Exp $";

// All extern value you want
extern unsigned int DebugLevel;
extern UINT8 SingleChannel;
extern UINT8 TypeOfCard;
extern p80211_caphdr_t wlan_header;

static CaptureArg ca;
static char errbuf[PCAP_ERRBUF_SIZE];
static char devname2[6];	// for cisco_cvs driver, it's wifi00

//-------------
int
selectChannelCISCO (char *devname, int channel)
{
  if (SingleChannel)
    {
      // CISCO card use an hardware scan
      return 1;
    }
  else
    {
      // CISCO card use an hardware scan
      return 1;
    }
}

int
shutCardCISCO (char *devname)
{
  char str[80];
  int result = 0;

  // Turn off monitor mode
  if (TypeOfCard == CISCO_CVS_CARD)
    sprintf (str, "echo \"Mode: i\" > /proc/driver/aironet/%s/Config",
	     devname2);
  else
    sprintf (str, "echo \"Mode: i\" > /proc/driver/aironet/%s/Config",
	     devname);
  debug (3, str, "\n");
  result += system (str);

  if (TypeOfCard == CISCO_CVS_CARD)
    sprintf (str, "echo \"XmitPower: 100\" > /proc/driver/aironet/%s/Config",
	     devname2);
  else
    sprintf (str,
	     "echo \"XmitPower: 100\" > /proc/driver/aironet/%s/Config",
	     devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "ifconfig %s -promisc up", devname);
  debug (3, str, "\n");
  result += system (str);

  return result;
}

int
openCardCISCO (char *devname)
{
  char str[80];
  int result = 0;
  if (TypeOfCard == CISCO_CVS_CARD)
    snprintf (devname2, 6, "eth%c", devname[4]);

  // Turn off monitor mode
  if (TypeOfCard == CISCO_CVS_CARD)
    sprintf (str,
	     "echo \"Mode: r\" > /proc/driver/aironet/%s/Config", devname2);
  else
    sprintf (str,
	     "echo \"Mode: r\" > /proc/driver/aironet/%s/Config", devname);
  debug (3, str, "\n");
  result += system (str);

  if (TypeOfCard == CISCO_CVS_CARD)
    sprintf (str,
	     "echo \"Mode: y\" > /proc/driver/aironet/%s/Config", devname2);
  else
    sprintf (str,
	     "echo \"Mode: y\" > /proc/driver/aironet/%s/Config", devname);
  debug (3, str, "\n");
  result += system (str);

  if (TypeOfCard == CISCO_CVS_CARD)
    sprintf (str,
	     "echo \"XmitPower: 1\" > /proc/driver/aironet/%s/Config",
	     devname2);
  else
    sprintf (str,
	     "echo \"XmitPower: 1\" > /proc/driver/aironet/%s/Config",
	     devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "ifconfig %s promisc up", devname);
  debug (3, str, "\n");
  result += system (str);

  return result;
}


// Get packet from card
int
getPacketCISCO (unsigned char *buf, int maxlen)
{
  struct pcap_pkthdr pktHdr;
  u_char *ret;
  fd_set rs;

  FD_ZERO (&rs);
  FD_SET (0, &rs);

  ret = (u_char *) pcap_next (ca.pcap, &pktHdr);
  // If no problem and packet is enought big (with data)
  if ((ret) && (pktHdr.len >= 1))
    {
      memcpy (buf, ret, pktHdr.len);
      // Fill Header
      // TODO : find this information in any maner ?!
      wlan_header.version = 0;	// It's a reduced capture frame format
      wlan_header.length = 0;	// Not used for now
      wlan_header.mactime = 0;
      wlan_header.hosttime = 0;
      wlan_header.phytype = 0;	// Not used for now
      wlan_header.channel = 0;
      wlan_header.datarate = 0;	// datarate is in units of 100kbps.
      wlan_header.antenna = 0;	// Not used for now
      wlan_header.priority = 0;	// Not used for now
      wlan_header.ssi_type = 0;	// Not used for now
      wlan_header.ssi_signal = 0;
      wlan_header.ssi_noise = 0;
      wlan_header.preamble = 0;	// Not used for now
      wlan_header.encoding = 0;	// Not used for now

      return pktHdr.len;
    }
  else
    {
      return (0);		/* Noting to read */
    }
}

int
openPacketCISCO (char *devname)
{
  int DataLink;
  ca.pcap = pcap_open_live (devname, 3000, 1, 0, errbuf);
  if (ca.pcap)
    {
      pcap_setnonblock (ca.pcap, 1, errbuf);
      DataLink = pcap_datalink (ca.pcap);
      switch (DataLink)
	{
	case DLT_PRISM_HEADER:
	  fatal ("pcap_datalink(ca.pcap) = %d = DLT_PRISM_HEADER\n",
		 DataLink);
	  ca.offset = 144;
	  break;
	case DLT_IEEE802_11:
	  debug (2, "pcap_datalink(ca.pcap) = %d = DLT_IEEE802_11\n",
		 DataLink);
	  ca.offset = 0;
	  break;
	case DLT_AIRONET_HEADER:
	  debug (2, "pcap_datalink(ca.pcap) = %d = DLT_AIRONET_HEADER:\n",
		 DataLink);
	  ca.offset = 0;
	  break;
	default:		//COOKED
	  debug (2, "pcap_datalink(ca.pcap) = %d = COOKED:\n", DataLink);
	  ca.offset = 160;
	}
      return 1;
    }
  return -1;
}

void
closePacketCISCO (void)
{
  pcap_close (ca.pcap);
}
