/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : analyse.h
 * Project : WifiScanner (c) 2002 Herv<E9> Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __analyse_h__
#define __analyse_h__

// Some values :-)
#define HISTOSIZE 37
#define POS_MAC 6
#define POS_SSID 24
#define POS_HISTO 56

#define SENSOFIDS_TS 5

// public declarations
void LogPutSN (UINT8 AddMac[WLAN_ADDR_LEN], UINT32 SN);
void LogPutRate (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 Rate);
void LogPutMaxRate (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 Rate);
void LogDetectedClient (UINT8 AddMac[WLAN_ADDR_LEN]);
void LogPutBSSID (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 BSSID[WLAN_ADDR_LEN]);
void LogPutDS (UINT8 BSSID[WLAN_ADDR_LEN]);
void LogPutWep (UINT8 BSSID[WLAN_ADDR_LEN], UINT8 hasWep);
void LogPutSSID (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 BSSID[WLAN_ADDR_LEN],
		 char *SSID);
void LogPutChannel (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 BSSID[WLAN_ADDR_LEN],
		    UINT8 Channel);
void LogPutIsAP (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 hasWep, UINT16 bcn_int);
void LogPutIsP2P (UINT8 AddMac[WLAN_ADDR_LEN]);
void LogPutOtherInformation (UINT8 AddMac[WLAN_ADDR_LEN],
			     char *OtherInformation);
void LogPutTimestamp (UINT8 AddMac[WLAN_ADDR_LEN], UINT64 TS);
void LogPutSeqNum (UINT8 AddMac[WLAN_ADDR_LEN],
		   UINT8 AddMacDst[WLAN_ADDR_LEN], UINT16 SeqNum);
void LogPutLastIV (UINT8 AddMac[WLAN_ADDR_LEN], UINT8 IV[4]);

void LogWriteReport (void);
void LogWriteDOT (FILE * filename);
void LogWritePanel (void);
void LogWriteHisto (void);

/* */
void DoSummary (void);
void WritePanel (UINT8 GoodPacket);

/* IDS */
UINT8 IDS (void);

#endif
