/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : $Name:  $
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/* $Id: include.h,v 1.36 2003/07/25 11:22:48 poggij Exp $ */

#ifndef _WIFISCAN_INCLUDE_H_
#define _WIFISCAN_INCLUDE_H_

#ifdef LWNG_2_0
// A little ugly hack ...
#define LWNG_14
#define LWNG_15
#define LWNG_16
#endif


#define ABSTRACTION_LAYER

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_MEMSET
#  error "You didn't have memset function, try to create it or change your OS"
# endif
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <sys/timeb.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/ioctl.h>
#include <asm/types.h>
#include <linux/netlink.h>
#include <errno.h>
#include <ctype.h>

#if defined(HAVE_LIBNCURSES) && defined(BUILD_CURSES)
#ifdef HAVE_LIBCURSES
#include <curses.h>
#else
#include <ncurses.h>
#endif
#endif

#ifdef LWNG_13
#error "CODE for this driver version is DEAD\nTry to update linux-wlan-ng code"
#endif

#ifdef WITH_THREAD
#include <pthread.h>
#endif

#include <pcap.h>
/* include from Linux-Wlan-NG */
//#include <wlan/wlan_compat.h>
/*
#include <wlan/p80211types.h>
#include <wlan/p80211msg.h>
#include <wlan/p80211meta.h>
#include <wlan/p80211metamsg.h>
#include <wlan/p80211metastruct.h>
#include <wlan/p80211metadef.h>
#include <wlan/p80211ioctl.h>
#include <wlan/p80211mgmt.h>
#include <wlan/version.h>
*/
#include <wlan/p80211hdr.h>
#ifdef LWNG_16
//#include <wlan/p80211conv.h>
#endif

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

#ifndef FALSE
#define FALSE (UINT8) 0
#endif
#ifndef TRUE
#define TRUE (UINT8) 1
#endif

#define UINT8_MAX       (0xffUL)
#define UINT16_MAX      (0xffffUL)
#define UINT32_MAX      (0xffffffffUL)

#define INT8_MAX        (0x7fL)
#define INT16_MAX       (0x7fffL)
#define INT32_MAX       (0x7fffffffL)

#define __WLAN_ATTRIB_PACK__            __attribute__ ((packed))
#define __WLAN_PRAGMA_PACK1__
#define __WLAN_PRAGMA_PACKDFLT__
#define __WLAN_INLINE__                 inline


/* Version */
// If the fourth number is <> 0 it's a CVS version only
#ifdef LWNG_13
#error "OBSOLETE Wlan driver version"
#endif
#define WIFISCANNER_VERSION WIFISCANNER_VERSION_NUM

/* Different size or constant */
#define MAX_BUFFER_SIZE 4096	/* Size of receive buffer */
#define DEVNAME_LEN 16
#define MCAST_GRP_SNIFF 0x00000002	/* Value used to notify netlink */
#define WLAN_STR_ADDR_LEN 18
#define MAXSIZE_OTHERINFORMATION 0x100
#define HISTORY_SIZE 4
#define MAX_NUMBER_OF_DETECTED_CLIENT 8192	/* Maximum of station */

/*
 * How many packet should we read if we have a signal on a channel????
 * After that we force a channel change anyway
 */
//#define CHANNEL_READ_COUNT 1 

/* We want to do only 7 channel scan per second 
   With this time, the capture was optimized
*/
#define TIME_TO_SLEEP_BEFORE_CHANGE_CHANNEL (1000/(14*1))	/* in ms */
#define TIMEOUT_TRY_TO_READ_PAQUET (1000000/(14/2))	/* s */

/*****************************/
/* MACRO                     */
/*****************************/

/*
Structure of bit field description
---------------------------------
|   |   |   |   |   |   |   |   |
| 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
|   |   |   |   |   |   |   |   |
+---------------+---------------+
| <- SUBTYPE -> | <-  TYPE   -> |

bit set     : do    or is    capable
bit not set : don't or isn't capable

bit 0 = 1 && Dedicated Access point || classic client (CPU + Card)
bit 1 = 1 && Emmit some Beacon || don't Emmit Beacon
bit 2 = 1 && mode P2P (Ad-Hoc) || Not
bit 3 = 1 && Data transmited || Not
bit 4 = 1 && Data go to DS || Not
bit 5 = 1 && Data go from DS || Not
*/

#define TYPE_BIT_AP      0
#define TYPE_BIT_BEACON  1
#define TYPE_BIT_P2P     2
#define TYPE_BIT_DATA    3
#define TYPE_BIT_TODS    4
#define TYPE_BIT_FROMDS  5

#define SET_TYPE_BIT_AP(x)      (x = ((x) | BIT0))
#define SET_TYPE_BIT_BEACON(x)  (x = ((x) | BIT1))
#define SET_TYPE_BIT_P2P(x)     (x = ((x) | BIT2))
#define SET_TYPE_BIT_DATA(x)    (x = ((x) | BIT3))
#define SET_TYPE_BIT_TODS(x)    (x = ((x) | BIT4))
#define SET_TYPE_BIT_FROMDS(x)  (x = ((x) | BIT5))

#define CLEAR_TYPE_BIT_AP(x)      (x =((x) & (~BIT0)))
#define CLEAR_TYPE_BIT_BEACON(x)  (x =((x) & (~BIT1)))
#define CLEAR_TYPE_BIT_P2P(x)     (x =((x) & (~BIT2)))
#define CLEAR_TYPE_BIT_DATA(x)    (x =((x) & (~BIT3)))
#define CLEAR_TYPE_BIT_TODS(x)    (x =((x) & (~BIT4)))
#define CLEAR_TYPE_BIT_FROMDS(x)  (x =((x) & (~BIT5)))

#define GET_TYPE_BIT_AP(x)      (((x) & (~BIT0)) >> TYPE_BIT_AP)
#define GET_TYPE_BIT_BEACON(x)  (((x) & (~BIT1)) >> TYPE_BIT_BEACON)
#define GET_TYPE_BIT_P2P(x)     (((x) & (~BIT2)) >> TYPE_BIT_P2P)
#define GET_TYPE_BIT_DATA(x)    (((x) & (~BIT3)) >> TYPE_BIT_DATA)
#define GET_TYPE_BIT_TODS(x)    (((x) & (~BIT4)) >> TYPE_BIT_TODS)
#define GET_TYPE_BIT_FROMDS(x)  (((x) & (~BIT5)) >> TYPE_BIT_FROMDS)

#define TYPE_BIT_00 "Client"
#define TYPE_BIT_01 "AP Base"
#define TYPE_BIT_02 "AP Base (STA in master mode)"
#define TYPE_BIT_03 "AP Base (dedicated)"
#define TYPE_BIT_04 "Ad-Hoc STA"
#define TYPE_BIT_05 "???5"
#define TYPE_BIT_06 "Ad-Hoc STA (beacon)"
#define TYPE_BIT_07 "Ad-Hoc STA"
#define TYPE_BIT_08 "STA Activity"
#define TYPE_BIT_09 "???9 Reserved"
#define TYPE_BIT_0A "???A Reserved"
#define TYPE_BIT_0B "???B Reserved"
#define TYPE_BIT_0C "???C Reserved"
#define TYPE_BIT_0D "???D Reserved"
#define TYPE_BIT_0E "???E Reserved"
#define TYPE_BIT_0F "???F Reserved"

#define SUBTYPE_BIT_00 "Radio only"
#define SUBTYPE_BIT_01 "Data To DS"
#define SUBTYPE_BIT_02 "Data From DS"
#define SUBTYPE_BIT_03 "Data AP to AP"
#define SUBTYPE_BIT_04 "???4 Reserved"
#define SUBTYPE_BIT_05 "???5 Reserved"
#define SUBTYPE_BIT_06 "???6 Reserved"
#define SUBTYPE_BIT_07 "???7 Reserved"
#define SUBTYPE_BIT_08 "???8 Reserved"
#define SUBTYPE_BIT_09 "???9 Reserved"
#define SUBTYPE_BIT_0A "???A Reserved"
#define SUBTYPE_BIT_0B "???B Reserved"
#define SUBTYPE_BIT_0C "???C Reserved"
#define SUBTYPE_BIT_0D "???D Reserved"
#define SUBTYPE_BIT_0E "???E Reserved"
#define SUBTYPE_BIT_0F "???F Reserved"

#define WLAN_SIZEOF_TYPEOFPACKET 6	/// 6 char for the human representation packet type

#define STR_YES "Yes"
#define STR_NO  "No"

#define STR_WEP    "Wep"
#define STR_NOWEP  "---"

#define STR_STA "STA"
#define STR_AP  "AP"

/** The maximum of DEBUG Level **/
#define MAX_DEBUG_LEVEL 3

/**
 * HELP of the program
 */
#define HELPTEXT1 \
"Call with no parameters or with the following options\n" \
"        -F FileName  - Save output to a file as well as stdout\n" \
"        -H Hop       - Number of hops do for rotating channel (default 1)\n" \
"        -S Channel   - Only listen on a specific Channel (1-14)\n" \
"        -V           - Write Version and quit\n" \
"        -D FileName  - Create a file of detected devices, in a .dot format\n" \
"        -d           - Write date in machine readable format\n" \
"        -i device    - Name of the interface (default wlan0)\n" \
"        -I           - Activate the IDS functions\n" \
"        -M number    - Max packets to capture before exit (0 = unlimited)\n" \
"        -N abcd      - Do not display Ack, Beacon, Control, Data\n" \
"        -v level     - For verbose, level 2 is for debugging\n" \
"        -t number    - Number of ms before channel change (default=71)\n" \
"        -c           - do not chek curses screen size\n" \
"        -C           - give the type of driver :\n" \
"                        cisco, cisco_cvs, prism(default), hostap\n"

#ifdef WITH_WIRETAP
#define HELPTEXT HELPTEXT1 \
"        -W FileName  - Save sniffed data to a file in PCAP format\n"
#else
#define HELPTEXT HELPTEXT1
#endif
// Option that was available but work is still in progress ;-)
//"        -G ??? \n"
//"        -w FileName  - Save weak IV packet to break WEP\n"
//"        -k FileName  - Save KeyStream in hex format (IV, KeyStream)\n"


/** Functions to determine if we must not display some packet */
#define IS_DISPLAY_ACK(x)     ( (x > 0) & 1)
#define IS_DISPLAY_BEACON(x)  ( (x > 1) & 1)
#define IS_DISPLAY_CONTROL(x) ( (x > 2) & 1)
#define IS_DISPLAY_DATA(x)    ( (x > 3) & 1)

/** Captured Frame Format */
#define WLAN_NG_CARD          1	/// original Captured Frame Format linux-wlan-ng
#define CISCO_CARD            2	/// Captured Frame Format output from Cisco Card
#define LUCENT_CARD           3	/// Captured Frame Format output from Lucent Card (Hermes chipset)
#define WLAN_NG_CARD_AVS_CFF2 4	/// Captured Frame Format from simplified linux-wlan-ng
#define PCAP_VIRTUAL_CARD     5	/// Captured Frame Format : PCAP file
#define HOSTAP_CARD           6	/// Captured Frame Format : HOSTAP driver
#define CISCO_CVS_CARD        7	/// Captured Frame Format : output from CISCO card (cvs version) with ethX and wifiX as interface

#ifndef phytype_fhss_dot11_97
#define phytype_fhss_dot11_97   1
#define phytype_dsss_dot11_97   2
#define phytype_irbaseband      3
#define phytype_dsss_dot11_b    4
#define phytype_pbcc_dot11_b    5
#define phytype_ofdm_dot11_g    6
#define phytype_pbcc_dot11_g    7
#define phytype_ofdm_dot11_a    8
#endif

// Code from of Linux-wlan-ng.0.2.0
/*================================================================*/
/* Constants */

#define WLAN_ETHADDR_LEN        6
#define WLAN_IEEE_OUI_LEN       3

#define WLAN_ETHCONV_ENCAP      1
#define WLAN_ETHCONV_RFC1042    2
#define WLAN_ETHCONV_8021h      3

#define WLAN_MIN_ETHFRM_LEN     60
#define WLAN_MAX_ETHFRM_LEN     1514
#define WLAN_ETHHDR_LEN         14

#define WLAN_SSID_MAXLEN            32

#ifndef P80211CAPTURE_VERSION

#define P80211CAPTURE_VERSION   0x80211001

/*================================================================*/
/* Types */

/**
 * Frame capture header.  (See doc/capturefrm.txt)
 */
__WLAN_PRAGMA_PACK1__ typedef struct p80211_caphdr
{
  UINT32 version __WLAN_ATTRIB_PACK__;
  UINT32 length __WLAN_ATTRIB_PACK__;
  UINT64 mactime __WLAN_ATTRIB_PACK__;
  UINT64 hosttime __WLAN_ATTRIB_PACK__;
  UINT32 phytype __WLAN_ATTRIB_PACK__;
  UINT32 channel __WLAN_ATTRIB_PACK__;
  UINT32 datarate __WLAN_ATTRIB_PACK__;
  UINT32 antenna __WLAN_ATTRIB_PACK__;
  UINT32 priority __WLAN_ATTRIB_PACK__;
  UINT32 ssi_type __WLAN_ATTRIB_PACK__;
  INT32 ssi_signal __WLAN_ATTRIB_PACK__;
  INT32 ssi_noise __WLAN_ATTRIB_PACK__;
  UINT32 preamble __WLAN_ATTRIB_PACK__;
  UINT32 encoding __WLAN_ATTRIB_PACK__;
} p80211_caphdr_t;
__WLAN_PRAGMA_PACKDFLT__
#endif // ifndef P80211CAPTURE_VERSION
/** signature of a winXP probe request */
#define WIN_XP_PROBE_SSID 0x14, 0x09, 0x03, 0x11, 0x04, 0x11, 0x09, 0x0E, \
                          0x0D, 0x0A, 0x0E, 0x19, 0x02, 0x17, 0x19, 0x02, \
                          0x14, 0x1F, 0x07, 0x04, 0x05, 0x13, 0x12, 0x16, \
                          0x16, 0x0A, 0x01, 0x0A, 0x0E, 0x1F, 0x1C, 0x12
/**
 * Overlay to directly index varius types of data
 * in Mgmt Frames
 */
  typedef struct
{
  UINT64 ts;			/// TimeStamp
  UINT16 bcn_int;		/// Beacon Interval
  UINT16 cap_info;		/// Capabilities infos
} FixedField_t;

/** Information that we search */
typedef struct
{
  char DestMac[WLAN_STR_ADDR_LEN];
  char SrcMac[WLAN_STR_ADDR_LEN];
  char BssId[WLAN_STR_ADDR_LEN];
  char SSID[WLAN_SSID_MAXLEN + 1];
  UINT8 hasWep;
  UINT8 isAp;
  UINT8 Channel;
  UINT8 SChannel;
  UINT8 Signal;
  UINT8 Noise;
  UINT8 Rate;
  UINT16 TypeOfClient;
  char OtherInformation[MAXSIZE_OTHERINFORMATION];
  char TypeOfPacket[WLAN_SIZEOF_TYPEOFPACKET + 1];
  UINT8 TypeSubtype;
  UINT8 IV[4];
} ScanResult_t;

/** Structure to stock collected data */
typedef struct
{
  UINT8 AddMac[WLAN_ADDR_LEN];
  UINT8 BSSID[WLAN_ADDR_LEN];
  char SSID[WLAN_SSID_MAXLEN + 1];
  UINT32 SNMax;			/** = Max of (S/N * 100) */
  UINT32 SNMin;			/** = Min of (S/N * 100) */
  UINT8 RateMax;
  UINT8 RateMin;
  UINT8 hasWep:1;
  UINT8 IsDS:1;			/** if == 1 then this client is in Wire Network (DS) */
  UINT8 IsAP:1;			/** if == 1 then this client is an AP */
  UINT8 IsP2P:1;		/** if == 1 then this client is a part of a P2P connection */
  UINT8 Channel;
  UINT16 bcn_int[HISTORY_SIZE];	/** History of beacon interval (IDS use) */
  UINT64 TimeStamp[HISTORY_SIZE];	/** History of TimeStamp (IDS use) */
  UINT16 SeqNum[HISTORY_SIZE];	/** History of Sequence Number (IDS use) */
  UINT16 SeqNumWithAP[HISTORY_SIZE];	/** History of Sequence Number (IDS use) */
  char OtherInformation[MAXSIZE_OTHERINFORMATION];
  UINT8 LastIV[4];
  float coef_a_TS;		/// for analyse Timestamp
  float coef_b_TS;
  UINT8 MaxSpeed;
} ClientInfo_t;

/** Structure to stock Statistics */
typedef struct
{
  UINT16 AP;			// Nb of different AP
  UINT16 STA;			// Nb of different STA
  UINT32 Beacon;		// Nb of beacon detected
  UINT16 SSID;			// Nb of different SSID
  UINT16 Channel;		// Nb of channel who a signal has been detected
  UINT16 INVLD;			// Nb of invalid packets
  UINT32 WeakIV;		// Nb of weak IV
  UINT32 CryptedPackets;	// Nb of Crypted Packets
  UINT32 Packets;		// Nb of packets
  UINT8 IV[4];			// Las IV
  UINT8 MaxSignal[14];		// Max strength of signal on each channel
} Statistics_t;

/** Capture Frame for Linux-WLAN-NG  */
typedef struct CaptureArg_t
{
  pcap_t *pcap;
  pcap_dumper_t *dump;
  int offset;
} CaptureArg;

#endif /* _WIFI_INCLUDE_H_ */
