/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : scanner.h
 * Project : WifiScanner (c) 2002 Herv<E9> Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
#ifndef __scanner_h__
#define __scanner_h__

#define DO_NOT_DISPLAY_ACK  ( ((DoNotDisplay & 1) == 1 ) && \
                              ( (WLAN_GET_FC_FTYPE (Res.TypeSubtype) == WLAN_FTYPE_CTL) && \
                                (WLAN_GET_FC_FSTYPE(Res.TypeSubtype) == WLAN_FSTYPE_ACK)  \
                              ) \
                            )

#define DO_NOT_DISPLAY_BEACON ( ((DoNotDisplay & 2) == 2 ) && \
                                ( Res.TypeSubtype == 0x80) \
                            )

#define DO_NOT_DISPLAY_CONTROL ( ((DoNotDisplay & 4) == 4 ) && \
                                 (WLAN_GET_FC_FTYPE (Res.TypeSubtype) == WLAN_FTYPE_CTL) \
                               )

#define DO_NOT_DISPLAY_DATA    ( ((DoNotDisplay & 8) == 8 ) && \
                                 (WLAN_GET_FC_FTYPE (Res.TypeSubtype) == WLAN_FTYPE_DATA) \
                               )

#endif
