/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : $Name:  $
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: hostap.c,v 1.4 2003/07/25 11:23:08 poggij Exp $
 */

// A lot of think is get from kismet
//  http://www.kismetwireless.net/

#include <include.h>
#include <src/hostap.h>
#include <src/crt_io.h>

static char *ID = "$Id: hostap.c,v 1.4 2003/07/25 11:23:08 poggij Exp $";

// All extern value you want
extern unsigned int DebugLevel;
extern UINT8 SingleChannel;
extern UINT8 TypeOfCard;
extern p80211_caphdr_t wlan_header;

static CaptureArg ca;
static char errbuf[PCAP_ERRBUF_SIZE];
static UINT8 wlan_payload[MAX_BUFFER_SIZE];

//-------------
int
selectChannelHOSTAP (char *devname, int channel)
{
  char str[80];
  int result = 0;

  // XXX - BAD !
  // A hack for my card
  if (channel == 14)
    channel = 13;
  // XXX - BAD !

  sprintf (str, "iwconfig %s channel %d", devname, channel);
  debug (3, str, "\n");
  result += system (str);

  return result;
}

int
shutCardHOSTAP (char *devname)
{
  char str[80];
  int result = 0;

  // Turn off monitor mode
  sprintf (str, "iwconfig %s mode managed", devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "iwconfig %s channel 1", devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "ifconfig %s -promisc up", devname);
  debug (3, str, "\n");
  result += system (str);

  return result;
}

int
openCardHOSTAP (char *devname)
{
  char str[80];
  int result = 0;

  // Turn on monitor mode
  sprintf (str, "prism2_param %s monitor_type 1", devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "iwconfig %s mode monitor_type", devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "iwconfig %s channel 1", devname);
  debug (3, str, "\n");
  result += system (str);

  sprintf (str, "ifconfig %s promisc up", devname);
  debug (3, str, "\n");
  result += system (str);

  return result;
}


// Get packet from card
int
getPacketHOSTAP (unsigned char *buf, int maxlen)
{
  struct pcap_pkthdr pktHdr;
  u_char *ret;
  fd_set rs;
  p80211msg_lnxind_wlansniffrm_t *Sniff_Frame;

  FD_ZERO (&rs);
  FD_SET (0, &rs);

  ret = (u_char *) pcap_next (ca.pcap, &pktHdr);
  // If no problem and packet is enought big (with data)
  if ((ret) && (pktHdr.len >= sizeof (p80211msg_lnxind_wlansniffrm_t)))
    {
      memcpy (buf, ret, pktHdr.len);
      Sniff_Frame = (p80211msg_lnxind_wlansniffrm_t *) buf;
      // Fill Header
      wlan_header.version = 0;	// It's a reduced capture frame format
      wlan_header.length = 0;	// Not used for now
      wlan_header.mactime = Sniff_Frame->mactime.data;
      wlan_header.hosttime = Sniff_Frame->hosttime.data;
      wlan_header.phytype = phytype_dsss_dot11_b;	// Not used for now
      wlan_header.channel = Sniff_Frame->channel.data;
      wlan_header.datarate = Sniff_Frame->rate.data * 5;	// datarate is in units of 100kbps.
      wlan_header.antenna = 0;	// Not used for now
      wlan_header.priority = 0;	// Not used for now
      wlan_header.ssi_type = 0;	// Not used for now
      wlan_header.ssi_signal = Sniff_Frame->signal.data;
      wlan_header.ssi_noise = Sniff_Frame->noise.data;
      wlan_header.preamble = 0;	// Not used for now
      wlan_header.encoding = 0;	// Not used for now
      // Fill data frame
      memcpy (wlan_payload, &buf[sizeof (p80211msg_lnxind_wlansniffrm_t)],
	      pktHdr.len - sizeof (p80211msg_lnxind_wlansniffrm_t));
      memcpy (buf, wlan_payload,
	      maxlen - sizeof (p80211msg_lnxind_wlansniffrm_t));

      if (pktHdr.len <= sizeof (p80211msg_lnxind_wlansniffrm_t))
	// Don't return negative value
	return 0;
      else
	return (pktHdr.len - sizeof (p80211msg_lnxind_wlansniffrm_t));
    }
  else
    {
      return (0);		/* Noting to read */
    }
}

int
openPacketHOSTAP (char *devname)
{
  int DataLink;
  ca.pcap = pcap_open_live (devname, 3000, 1, 0, errbuf);
  if (ca.pcap)
    {
      pcap_setnonblock (ca.pcap, 1, errbuf);
      DataLink = pcap_datalink (ca.pcap);
      switch (DataLink)
	{
	case DLT_PRISM_HEADER:
	  debug (3, "pcap_datalink(ca.pcap) = %d = DLT_PRISM_HEADER\n",
		 DataLink);
	  ca.offset = 144;
	  break;
	case DLT_IEEE802_11:
	  debug (3, "pcap_datalink(ca.pcap) = %d = DLT_IEEE802_11\n",
		 DataLink);
	  ca.offset = 0;
	  break;
	case DLT_AIRONET_HEADER:
	  debug (3, "pcap_datalink(ca.pcap) = %d = DLT_AIRONET_HEADER:\n",
		 DataLink);
	  ca.offset = 0;
	  break;
	default:		//COOKED
	  debug (3, "pcap_datalink(ca.pcap) = %d = COOKED:\n", DataLink);
	  ca.offset = 160;
	}
      return 1;
    }
  return -1;
}

void
closePacketHOSTAP (void)
{
  pcap_close (ca.pcap);
}
