/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : driver.h
 * Project : WifiScanner (c) 2002 Herv<E9> Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
#ifndef __DRIVER_H__
#define __DRIVER_H__

int NextChannel (char *devname, unsigned int NumberOfHop);
void PrintScaleChannel (int channel);
int selectChannel (char *devname, int channel);
int shutCard (char *devname);
int openCard (char *devname);

#ifndef DLT_PRISM_HEADER
#define DLT_PRISM_HEADER 119
#endif

// Size is more than 1500 ? so we take a BLOCK :-)
// TODO : choice a better size, more thruly
#define WLAN_DATA_SIZE 2048

// Public declarations
#ifdef LWNG_14
int openPacket (char *devname);
#else
int openPacket (void);
#endif // ifdef LWNG_14

void closePacket (void);
int getPacket (unsigned char *buf, int maxlen, unsigned int timeout);

#endif // ifndef __DRIVER_H__
