/* Linux Prism II Stumbler - Utility Scan for 802_11 networks under Linux
 * 
 * File : crt_io.c
 * Project : WifiScanner (c) 2002 Herv Schauer Consultants
 * Usage : This utility is written for use with IEEE 802.11 adapters based
 * on Intersil's PRISM II chipset (PCMCIA).
 * 
 * Base code was from prismstumbler Jan Fernquist <Jan.B.Fernquist@telia.com>
 * and wlanctl from www.linux-wlan.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: crt_io.c,v 1.5 2003/07/25 11:23:08 poggij Exp $
 */

#include <include.h>
#include <src/crt_io.h>
#include <src/interface.h>

extern UINT8 CursesIsInUse;
extern UINT8 DebugLevel;
#ifdef HAVE_LIBNCURSES
extern WINDOW *RealTime_WND;
#endif
#ifdef WITH_THREAD
extern pthread_mutex_t screen_mutex;
#endif


/*
 * Some internal forward refs
 */

/*----------------------------------------------------------------
   Function to write a message and exit (fatal error)
   Write with and without curses
   exit curses environment before all thinks but after 3 secondes
     so we can read screen before death condition
----------------------------------------------------------------*/
void
fatal (char *fmt, ...)
{
  va_list ap;
#ifdef HAVE_LIBNCURSES
  if (CursesIsInUse == TRUE)
    RefreshAllWND ();		// Refresh All Windows
  if (DebugLevel >= 1)
    sleep (3);			// Sleep for 3 seconds
#else
  fflush (stdout);		// Refresh stdout buffer
#endif
  va_start (ap, fmt);
#ifdef HAVE_LIBNCURSES
  if (CursesIsInUse == TRUE)
    EndCurses ();
#endif
  vfprintf (stderr, fmt, ap);
  va_end (ap);
  exit (EXIT_FAILURE);
}

/*----------------------------------------------------------------
   Function to write DEBUG informations
   Write with and without curses
   If DebugLevel is greater than 0 we refresh screen else not
----------------------------------------------------------------*/
void
debug (UINT8 DL, char *fmt, ...)
{
  va_list ap;

  if (DebugLevel < DL)
    return;			// Return if debug level is not enougth
  if (CursesIsInUse == FALSE)
    fflush (stdout);		// Refresh stdout buffer
  va_start (ap, fmt);
#ifdef HAVE_LIBNCURSES
  if (CursesIsInUse == TRUE)
    {
#ifdef WITH_THREAD
      pthread_mutex_lock (&screen_mutex);
#endif
      vwprintw (RealTime_WND, fmt, ap);
      if (DebugLevel > 0)
	wrefresh (RealTime_WND);
#ifdef WITH_THREAD
      pthread_mutex_unlock (&screen_mutex);
#endif
    }
  else
    {
#endif
      vfprintf (stderr, fmt, ap);
      fflush (stderr);
#ifdef HAVE_LIBNCURSES
    }
#endif
  va_end (ap);
}

void
warning (char *fmt, ...)
{
  va_list ap;

  if (CursesIsInUse == FALSE)
    fflush (stdout);		// Refresh stdout buffer
  va_start (ap, fmt);
#ifdef HAVE_LIBNCURSES
  if (CursesIsInUse == TRUE)
    {
#ifdef WITH_THREAD
      pthread_mutex_lock (&screen_mutex);
#endif
      vwprintw (RealTime_WND, fmt, ap);
      if (DebugLevel > 0)
	wrefresh (RealTime_WND);
#ifdef WITH_THREAD
      pthread_mutex_unlock (&screen_mutex);
#endif
    }
  else
    {
#endif
      vfprintf (stderr, fmt, ap);
      fflush (stderr);
#ifdef HAVE_LIBNCURSES
    }
#endif
  va_end (ap);
}

/********************/
void
DumpHexPaquets (WINDOW * RealTime_WND, unsigned char msgbuf[], int recvlen)
{
  int n, i, end;

#ifdef WITH_THREAD
  pthread_mutex_lock (&screen_mutex);
#endif
  wprintw (RealTime_WND, "MSG=\n");

  for (n = 0; n < recvlen; n += 16)
    {
      end = recvlen - n;
      if (end > 16)
	end = 16;
      wprintw (RealTime_WND, "0x%04X - ", n);
      for (i = 0; i < 16; i++)
	{
	  /* Write only packet, not garbage ;-) */
	  if (i < end)
	    wprintw (RealTime_WND, "%02X", (UINT8) msgbuf[n + i]);
	  else
	    break;
	  //wprintw (RealTime_WND, "  ");
	  /* Separator every 2 bytes */
	  if (!((i + 1) % 2))
	    wprintw (RealTime_WND, " ");
	}
      for (i = 0; i < 16; i++)
	{
	  // Print caractere if it's printable
	  if (i < end)
	    {
	      if (msgbuf[n + i] >= 0x20 && msgbuf[n + i] <= 0x7E)
		wprintw (RealTime_WND, "%c", (char) msgbuf[n + i]);
	      else
		wprintw (RealTime_WND, ".");
	    }
	}
      /* End of line each 16 bytes */
      wprintw (RealTime_WND, "\n");
    }
  wrefresh (RealTime_WND);
#ifdef WITH_THREAD
  pthread_mutex_unlock (&screen_mutex);
#endif
}
