#ifndef CRC32_H
#define CRC32_H

/* $Id: crc-32.h,v 1.6 2003/07/25 11:23:08 poggij Exp $ */
/* Code stealth from jffs2 source */

//#include <include.h>
#define UINT32 unsigned long

extern const UINT32 crc32_table[256];

/* Return a 32-bit CRC of the contents of the buffer. */

static inline UINT32
doFCS (const void *ss, int len)
{
  const unsigned char *s = ss;
  UINT32 val = 0xffffffff;
  while (--len >= 0)
    val = crc32_table[(val ^ *s++) & 0xff] ^ (val >> 8);
  return val;
}

#endif
