{ͻ
  Unit      _Windows.pas                                 
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      27.03.90                                     
                                                         
  Update    18.12.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Fenstertechniken als Routinen.               
 ͼ}
Unit _Windows;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  _Declare;                         {Unit aus dem Unitsystem}

const {Globale Konstanten}
  _MaxWin     = 25;              {Max. zu ffnenden Fenster}
  _ScrNr: byte = 0;         {Noch kein Bildschirm gesichert}

type {Globale Datentypen}
  _WinPktRec = record         {Aktuelle Fensterkoordinaten.}
                 x1,y1,x2,y2,    {Werden durch die Prozedur}
                 Breite,Hoehe: byte; {_Window aktualisiert.}
               end;

var {Globale Variablen}
  _Win: _WinPktRec;   {Variable fr akt. Fensterkoordinaten}

  {Verzeichnis der globalen Routinen}

  procedure _Window(x1,y1,x2,y2: byte);
  procedure _NormWindow;
  procedure _GetOldWinPar(var x1,y1,x2,y2,CurX,CurY: byte);
  procedure _SetOldWinPar(x1,y1,x2,y2,CurX,CurY: byte);
  procedure _SaveScr;
  procedure _RestoreScr;
  procedure _MakeWin(Nr,x1,y1,x2,y2,Rand,C1,C2: byte;
                              StrOben,StrUnten: _WorkStr);
  procedure _CloseWin(Nr: byte);
  procedure _GotoWin(Nr: byte; Clear: boolean);

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Crt,                     {Unit aus dem Turbo Pascal-System}
  _IO,_Check;                      {Units aus dem Unitsystem}

const {Lokale Konstanten}
  _MaxSaveScr       = 25;  {Max. zu speichernde Bildschirme}

type {Lokale Datentypen}
  _ScrAry = array[1.._MaxSaveScr] {Gespeicherte Bildschirme}
             of _BildPointer;

  _CurPosAry = array[1.._MaxSaveScr]    {Cursorposition fr}
                of record                 {gesicherte Bild-}
                     x,y: byte;              {schirminhalte}
                   end;

  _WinParAry = array[1.._MaxWin]          {Fensterparameter}
                of record
                     x1,y1,x2,y2,
                     Rand,C1,C2,
                     WoX,WoY     : byte;    {Cursorposition}
                     StrOben,
                     StrUnten    : _WorkStr;
                   end;

  _WinInitAry = array[1.._MaxWin]     {Ob fr Fensternummer}
                 of boolean;     {_MakeWin aufgerufen wurde}

var {Lokale Variablen}
  _Screen   : _ScrAry;            {Gespeicherte Bildschirme}
  _ScrCurPos: _CurPosAry;   {Cursorposition vor dem Sichern}
  _WinPar   : _WinParAry;                 {Fensterparameter}
  _WinInit  : _WinInitAry;          {Fenster initialisiert?}
  _Zv       : byte;      {Zhlvariabel Initialisierungsteil}

{ͻ
  _Window                                                 
 Ķ
  Ergnzt die Prozedur Window aus der Standard-Unit Crt.  
  x1/y1 ist linke obere, x2/y2 die rechte untere Ecke des 
  Bildschirms. Nach jedem Aufruf dieser Prozedur werden   
  die aktuellen Fensterkoordinaten in der Variablen _Win  
  abgelegt und stehen fr evtl. Abfragen zur Verfgung.   
  Neben  den Koordinaten enthlt die Variable auch die    
  Fensterhhe und -breite. Liegen die Koordinaten auer-  
  halb des gltigen Bereiches (1,1,80,25) hat der Aufruf  
  der Routine keine Auswirkung.                            
 ͼ}
procedure _Window(x1,y1,x2,y2: byte);
begin
  if   _IntRange(1,80,x1) and _IntRange(1,25,y1)
   and _IntRange(1,80,x2) and _IntRange(1,25,y2)
   and (x1 <= x2) and (y1 <= y2) then
   begin
     Window(x1,y1,x2,y2);
     _Win.x1:= x1;  _Win.y1:= y1;
     _Win.x2:= x2;  _Win.y2:= y2;
     _Win.Breite:= x2-x1+1;  _Win.Hoehe:= y2-y1+1;
   end; {if}
end;
{ͻ
  _NormWindow                                             
 Ķ
                                                          
  Setzt die volle Fenstergre (1,1,80,25). Die Fenster-  
  parameter der Variablen _Win werden aktualisiert.       
 ͼ}
procedure _NormWindow;
begin
  _Window(1,1,80,25);
end;
{ͻ
  _GetOldWinPar                                           
 Ķ
  Sichert die letzte Fenstergre und die Cursorposition  
  und liefert die Werte an die aufrufende Routine als Var-
  Parameter zurck.                                       
 ͼ}
procedure _GetOldWinPar(var x1,y1,x2,y2,CurX,CurY: byte);
begin
  x1  := _Win.x1;     y1  := _Win.y1;
  x2  := _Win.x2;     y2  := _Win.y2;
  CurX:= WhereX;      CurY:= WhereY;
end;
{ͻ
  _SetOldWinPar                                           
 Ķ
  Setzt wieder die durch _GetOldWinPar gesicherten        
  Fensterparameter.                                       
 ͼ}
procedure _SetOldWinPar(x1,y1,x2,y2,CurX,CurY: byte);
begin
  _Window(x1,y1,x2,y2);
  GotoXY(CurX,CurY);
end;
{ͻ
  _SaveScr                                                
 Ķ
  Speichert den momentanen Bildschirminhalt und legt ihn  
  in der Variablen _Screen ab. Dabei wird die Bildschirm- 
  Nummer automatisch festgelegt.                          
 ͼ}
procedure _SaveScr;
var
  Error: _WorkStr;

begin
  Error:= 'Mehr als ' + _NumToStr(_MaxSaveScr,3,0) +
        ' Bild(er) auf dem Heap. Programm wird abgebrochen!';
  if _ScrNr < _MaxSaveScr then
  begin
    _HeapMin(4000);                   {Mindestens 4000 Byte}
    inc(_ScrNr);                           {Nr um 1 erhhen}
    _ScrCurPos[_ScrNr].x:= WhereX;  {Cursorposition sichern}
    _ScrCurPos[_ScrNr].y:= WhereY;
    New(_Screen[_ScrNr]);                {Variable erzeugen}
    _BildAufHeap(_Screen[_ScrNr]);          {Bild speichern}
  end {if}
  else begin
         _ErrorBox(Error);
         NormVideo;
         _NormWindow;
         Clrscr;
         Halt;
       end; {else}
end;
{ͻ
  _RestoreScr                                             
 Ķ
  Holt den zuletzt mit _SaveScr gesicherten Bildschirmin- 
  halt zurck und gibt den dyn. belegten Speicherplatz auf
  dem Heap wieder frei.                                   
 ͼ}
procedure _RestoreScr;
begin
  if _ScrNr > 0 then
  begin
    _BildVomHeap(_Screen[_ScrNr],false);
    Dispose(_Screen[_ScrNr]);       {Dyn. Variable vom Heap}
    GotoXY(_ScrCurPos[_ScrNr].x,       {Alte Cursorposition}
           _ScrCurPos[_ScrNr].y);
    dec(_ScrNr);                       {Nr um 1 erniedrigen}
  end;
end;
{ͻ
  _MakeWin                                                
 Ķ
  Generiert auf dem Bildschirm ein Fenster mit der Ord-   
  nungszahl Nr und mit den Koordinaten x1/y1 (linke       
  obere), x2/y2 (rechte untere Ecke). Die Randwerte sind  
  0 (kein Rand), 1 (schmaler Rand) und 2 (breiter Rand).  
  Mit C1 (Vordergrund) und C2 (Hintergrund)  knnen Farben
  ausgewhlt werden. Die Werte sind der Standard-Unit Crt 
  zu entnehmen.                                           
  StrOben und StrUnten geben Zeichenketten an, die ent-   
  weder oben oder/und unten in den Rahmen geschrieben     
  werden. Soll kein Text in den Rahmen geschrieben werden,
  so ist ein Leerstring zu bergeben. Das Fenster wird mit
  der neuen Hintergrundfarbe gelscht und um die Rahmen-  
  breite verkleinert. Werden fr die Farben oder den Rand 
  ungltige Werte bergeben, so gelten Voreinstellungen!  
                                                          
  ACHTUNG! Die letzten 5 Fenster (_MaxWin-4.._MaxWin) sind
           dem Unitsystem vorbehalten und drfen von Ihnen
           nicht verwendet werden!                        
 ͼ}
procedure _MakeWin(Nr,x1,y1,x2,y2,Rand,C1,C2: byte;
                         StrOben,StrUnten: _WorkStr);

begin
  if _IntRange(1,_MaxWin,Nr) then
  begin
    _WinInit[Nr]:= true;         {Fenster-Nr. initialisiert}
    {Neue Farben prfen und setzen}
    _GueltigeFarben(C1,C2);
    TextColor(C1);
    TextBackground(C2);
    {Fenster festlegen}
    _Window(x1,y1,x2,y2);
    Clrscr;
    _NormWindow;                        {Wieder volle Gre}
    {Randwert prfen}
    if not _IntRange(0,2,Rand) then Rand:= 0;
    {StrOben, StrUnten auf Lnge prfen}
    if Length(StrOben)  > x2-x1-3 then StrOben := '';
    if Length(StrUnten) > x2-x1-3 then StrUnten:= '';
    {Fensterparameter fr _GotoWin sichern}
    _WinPar[Nr].x1  := x1;    _WinPar[Nr].y1:= y1;
    _WinPar[Nr].x2  := x2;    _WinPar[Nr].y2:= y2;
    _WinPar[Nr].Rand:= Rand;
    _WinPar[Nr].C1  := C1;    _WinPar[Nr].C2 := C2;
    _WinPar[Nr].WoX := 1;     _WinPar[Nr].WoY:= 1;
    _WinPar[Nr].StrOben := StrOben;
    _WinPar[Nr].StrUnten:= StrUnten;
    {Rand und Str setzen und Fenster verkleinern}
    case Rand of
      0: begin
           _WriteZen(x1+1,x2-1,y1,StrOben,false,false);
           _WriteZen(x1+1,x2-1,y2,StrUnten,false,false);
         end;
      1: _Umrandung(x1,y1,x2,y2,196,false,StrOben,StrUnten);
      2: _Umrandung(x1,y1,x2,y2,205,false,StrOben,StrUnten);
    end; {case}
    _Window(x1+1,y1+1,x2-1,y2-1);     {Jetzt richtige Gre}
  end; {if}
end;
{ͻ
  _CloseWin                                               
 Ķ
  Sichert die letzte Cursorposition vor dem Verlassen des 
  Fensters. Der Cursor wird mit der Prozedur _GotoWin     
  wieder auf diese Position gesetzt.                      
 ͼ}
procedure _CloseWin(Nr: byte);
begin
  if _IntRange(1,_MaxWin,Nr) and _WinInit[Nr] then
  begin
    _WinPar[Nr].WoX:= WhereX;               {Spalte sichern}
    _WinPar[Nr].WoY:= WhereY;                {Zeile sichern}
    _NormWindow;                  {Wieder vollen Bildschirm}
  end;
end;
{ͻ
  _GotoWin                                                
 Ķ
  Wechselt in ein mit _MakeWindow bereits initialisiertes 
  Fenster mit der Ordnungsnummer Nr. Dabei werden alle    
  Fensterparameter automatisch aktiviert. Ist Clear       
  gleich True, wird das Fenster mit der Hintergrundfarbe  
  gelscht. Der Aufruf dieser Routine hat nur dann einen  
  Sinn, wenn das Fenster nicht verdeckt ist. Wird ein     
  nicht initialisiertes Fenster angesprochen, hat der Auf-
  ruf dieser Routine keine Wirkung.                       
 ͼ}
procedure _GotoWin(Nr: byte; Clear: boolean);
begin
  if _IntRange(1,_MaxWin,Nr) and _WinInit[Nr] then
  begin
    With _WinPar[Nr] do
    begin
      _Window(x1+1,y1+1,x2-1,y2-1);
      TextColor(C1);
      TextBackground(C2);
    end; {With}
    if Clear then Clrscr;
    GotoXY(_WinPar[Nr].WoX,_WinPar[Nr].WoY);
  end; {if}
end;
{ͻ
  Initialisierungs-Teil (Ausfhrungsteil)                 
 ͼ}
begin
  {Fensterverwaltung initialisieren}
  _NormWindow;
  for _Zv:= 1 to _MaxWin                 {Noch kein Fenster}
   do _WinInit[_Zv]:= false;                 {initialisiert}
{ͻ
  End of Unit                                             
 ͼ}
end.