{ͻ
  Unit      _Help.pas                                    
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      19.05.90                                     
                                                         
  Update    21.05.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Hilfe-Routinen.                              
 ͼ}
Unit _Help;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  _Declare;                        {Unit aus dem Unit-System}

const {Globale Konstanten}
  _SysHelpName: _WorkStr = 'SysHelp.Hlp';

var {Globale Variablen}
  _SysHelpFile: Text;
  _OldWinPar  : record
                  x1,y1,x2,y2,           {Fenster-Eckpunkte}
                  CurX,CurY  : byte;        {Cursorposition}
                end;

  {Verzeichnis der globalen Routinen}

  procedure _BeforeHelpWin;
  function _HelpWin(HelpStr: _WorkStr;
                    var HelpFile: Text): boolean;
  procedure _AfterHelpWin;
  procedure _OpenHelpFile(var HelpFile: Text;
                          var HelpName: _WorkStr);
  procedure _CloseHelpFile(var HelpFile: Text);
  procedure _EndOfProgram;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Crt,Dos,                {Unit aus dem Turbo Pascal-System}
  _IO,_Disk,_Windows;            {Units aus dem Unit-System}

const {Lokale Konstanten}
  _TextColorHelpWin = White;              {Fr Hilfefenster}
  _BackColorHelpWin = Blue;
  _RandHelpWin      = 2;                      {Breiter Rand}

{ͻ
  FehlerHelpFile                                          
 Ķ
  Gibt eine Fehlermeldung aus, wenn mit dem Hilfesystem   
  etwas nicht stimmt.                                     
 ͼ}
procedure FehlerHelpFile(Nr: byte);
var
  St: _WorkStr;

begin
  case Nr of
    1: St:= 'Hilfesystem nicht initialisiert!';
    2: St:= 'Falsche Fensterparameter!';
    3: St:= 'Hilfetext nicht gefunden!';
  end; {case}
  _ErrorBox(St);
end;
{ͻ
  _BeforeHelpWin                                          
 Ķ
  Sichert aktuelle Fensterparameter, Cursorposition und   
  Bildschirminhalt. Sollte stets vor _HelpWin aufgerufen  
  werden.                                                 
 ͼ}
procedure _BeforeHelpWin;
begin
  with _OldWinPar do
  begin
    x1  := _Win.x1;     y1  := _Win.y1;
    x2  := _Win.x2;     y2  := _Win.y2;
    CurX:= WhereX;      CurY:= WhereY;
  end; {with}
  _NormWindow;
  _SaveScr;
end;
{ͻ
  _HelpWin                                                
 Ķ
  HelpStr : Text, der die Hilfestellung markiert.         
  HelpFile: Datei, die den Hilfetext enthlt.             
                                                          
  Definiert auf dem Bildschirm ein Hilfefenster mit den   
  vordefinierten (konstanten) Farben und dem Rand und     
  fllt es mit dem entsprechenden Text. Die Datei HelpFile
  mu bereits geffnet sein.                              
 ͼ}
function _HelpWin(HelpStr: _WorkStr;
                  var HelpFile: Text): boolean;

var
  x1,y1,                                   {Ecke oben links}
  x2,y2,                                  {Ecke oben rechts}
  i        : byte;                            {Zhlvariable}
  Ok       : boolean;                  {Ob Einlesen beendet}
  Zeile,                          {Eine Zeile aus HelpDatei}
  StrOben,
  StrUnten : _WorkStr;               {Texte im Hilfefenster}
  St       : array[1..23]
               of _WorkStr;                     {Hilfetexte}
  Anz      : byte;                       {Anzahl Hilfetexte}

begin
  Ok:= false;                                  {Anfangswert}
  {$I-} Reset(HelpFile); {$I+}
  if IOResult = 0 then                  {Datei ist geffnet}
  begin
    Anz:= 0;
    while not Eof(HelpFile) and not Ok do
    begin
      readln(HelpFile,Zeile);             {Eine Zeile lesen}
      if Zeile = '#' + HelpStr then
      begin                               {HelpStr gefunden}
        {$I-}
        readln(HelpFile,x1,y1,x2,y2); {Koordinaten einlesen}
        {$I+}
        if IOResult = 0 then
        begin
          readln(HelpFile,StrOben);
          readln(HelpFile,StrUnten);
          while not Eof(HelpFile)
           and (Anz < 23) and not Ok do
          begin
            readln(HelpFile,Zeile);
            if Zeile <> '#end' then
            begin
              Inc(Anz);
              St[Anz]:= Zeile;
            end
            else Ok:= true;
          end; {while}
        end
        else FehlerHelpFile(2);
      end; {if}
    end; {while}
  end
  else begin
         FehlerHelpFile(1);
         _HelpWin:= false;
         Exit;                           {Routine verlassen}
       end;
  if Ok then
  begin
    _MakeWin(_MaxWin,x1,y1,x2,y2,_RandHelpWin,
             _TextColorHelpWin,_BackColorHelpWin,
             StrOben,StrUnten);
    for i:= 1 to Anz do _Write(1,i,St[i]);
    _HelpWin:= true;
  end
  else begin
         FehlerHelpFile(3);
         _HelpWin:= false;
       end;
end;
{ͻ
  _AfterHelpWin                                           
 Ķ
  Setzt wieder die aktuellen Fensterparameter, Cursor-    
  position und den Bildschirminhalt, der vor dem Aufruf   
  von _HelpWin aktiviert war. Sollte stets nach _HelpWin  
  aufgerufen werden.                                      
 ͼ}
procedure _AfterHelpWin;
begin
  _RestoreScr;
  with _OldWinPar do
  begin
    _Window(x1,y1,x2,y2);
    GotoXY(CurX,CurY);
  end;
  _SetConfigColor;
end;
{ͻ
  _OpenHelpFile                                           
 Ķ
  Vervollstndigt den Dateinamen einer Datei mit Hilfe-   
  texten und ffnet die Datei anschlieend, wenn sie vor- 
  handen ist. Ist die Datei nicht vorhanden, gibt es z.Zt.
  noch keine Fehlermeldung. Hilfetexte knnen in dem auf- 
  rufenden Programm dann jedoch nicht verwendet werden.   
 ͼ}
procedure _OpenHelpFile(var HelpFile: Text;
                        var HelpName: _WorkStr);
begin
  HelpName:= FExpand(HelpName);
  if _DateiExist(HelpName) then
  begin
    Assign(HelpFile,HelpName);
    Reset(HelpFile);
  end;
end;
{ͻ
  _CloseHelpFile                                          
 Ķ
  Schliet eine Datei mit Hilfetexten. Ist die Datei nicht
  geffnet, folgt keine Fehlermeldung. Der Aufruf der     
  Routine ist dann wirkungslos.                           
 ͼ}
procedure _CloseHelpFile(var HelpFile: Text);
var i: byte;

begin
  {$I-} Close(HelpFile); {$I+}
  i:= IOResult;
end;
{ͻ
  _EndOfProgram                                           
 Ķ
  Schliet die System-Hilfedatei, setzt die beim Programm-
  start gltigen Farben und lscht den Bildschirm.        
 ͼ}
procedure _EndOfProgram;
begin
  _CloseHelpFile(_SysHelpFile);
  _NormWindow;
  NormVideo;
  ClrScr;
end;
{ͻ
  Initialisierungs-Teil (Ausfhrungsteil)                 
 ͼ}
begin
  _OpenHelpFile(_SysHelpFile,_SysHelpName);
  _BeforeHelpWin;
{ͻ
  End of Unit                                             
 ͼ}
end.