Program DAT_Stat(Input,Output);
uses dos,crt,my2,ts_lib,version;
var f: file;
    g, stdout:text;
    ts : array[0..9999] of byte;
    ts_head : array[1..32] of byte;
    size : word;
    name,name2,tmp,_tmp,_tmp_,id_name : string;
    stat : array[1..25] of word;
    a,b,c : word;
    e:longint;
    cha:char;
    id,_x_:byte;
    tmp_ : array[1..5] of string[30];
    mat,mat1,mat2:real;
    count:word;
    all,db:boolean;


procedure HELP;
begin
   writeln(stdout,'SYNTAX  : DAT-STAT.EXE <Datfile> [<Outputfile> [<ID>] [DB]]');
   writeln(stdout);
   writeln(stdout,'OPTIONS : <Datfile>    Datfile to show a statistic from');
   writeln(stdout,'OPTIONAL: <Outputfile> Outputfile to write the data to');
   writeln(stdout,'          <ID>         ID to write into the Outputfile');
   writeln(stdout,'          DB           The outputfile generated is a generic database format');
   writeln(stdout,'The <ID> parameter may only be used together with an outputfile');
   writeln(stdout);
   writeln(stdout,'If only the Datfile is mentioned, a statistic will be displayed.');
   writeln(stdout,'If the outputfile is given, a Thc-Scan like outputfile is created.');
   writeln(stdout,'If both optional parameters are present, all those IDs will be written into');
   writeln(stdout,'the outputfile with their FULL PHONE NUMBER!');
   writeln(stdout,'For <ID> you can either use a number id (e.g. 64) (with an X added at the end');
   writeln(stdout,'of the number to match all ringcounts) or use a name id (e.g. CARRIER, VMB');
   writeln(stdout,'etc.). Note that name ids always affect all ringcounts.');
   writeln(stdout,'For "DB" the generic ODBC format is used, using "|" as a delimiter.');
   writeln(stdout,'You can look this up in the help file DATFILE.DOC .');
   halt;
end;

procedure Error(typ:byte);
begin
     write('Error (',typ,') : ');
     case typ of
          1:writeln('Can`t find Datfile!');
          2:writeln('Not a THC-SCAN DATfile!');
          3:writeln('Can`t create outputfile!');
          4:writeln('Invalid ID : ',ParamStr(3));
     end;
     halt;
end;

Function Proz(wert:word):byte; Var x,y,z:real;
begin
   x:=wert; y:=size;
   z:=(wert/size)*100;
   Proz:=Round(z);
end;

procedure Stats;
begin
   for a:=0 to size-1 do begin
      b:=ts[a];
      case b of
        0:inc(stat[1]);
        1,16..23:inc(stat[2]);
        8..15:inc(stat[3]);
        24..31:inc(stat[4]);
        32..39:inc(stat[5]);
        40..47:inc(stat[6]);
        48..55:inc(stat[7]);
        56..63:inc(stat[8]);
        64..71,96..119:inc(stat[9]);
        72..79:inc(stat[10]);
        80..87:inc(stat[11]);
        88..95:inc(stat[12]);
        120..127:inc(stat[13]);
        128..135:inc(stat[14]);
        136..143:inc(stat[15]);
        144..151:inc(stat[16]);
        152..159:inc(stat[17]);
        168..191:inc(stat[18]);
        192..215:inc(stat[19]);
        224..231:inc(stat[20]);
        232..239:inc(stat[21]);
        240..247:inc(stat[22]);
        248..255:inc(stat[23]);
      end;
   end;
end;

function acht(typ:byte):byte;
begin
   typ:=typ div 8;
   acht:=Trunc(typ*8);
end;

function phone_no(typ:word):string;
begin
   _tmp:=no2str(typ,_x_); b:=1; _tmp_:=''; c:=1;
   while (b<=_x_)and(c<=Length(tmp)) do begin
     while (tmp[c]<>'X') do
           begin _tmp_:=_tmp_+tmp[c]; inc(c); end;
     inc(c); _tmp_:=_tmp_+_tmp[b]; inc(b);
   end;
   phone_no:=_tmp_;
end;

Procedure MakeLog; Var nam:string;
begin
   if not db then begin
    writeln(stdout,'Makeing a THC-SCAN.LOG like output file : ',name2);
    writeln(g,'DAT File : ',name,' (created with THC-SCAN version v',Chr(ts_head[3]),'.',Chr(ts_head[4]),')');
    if tmp<>'' then writeln(g,'Dialmask : ',tmp) else writeln(g,'Dialmask : <none>'); writeln(g);
   end else writeln(stdout,'Making a GENERIC DATABASE output file : ',name2);
    case size of 10:_X_:=1; 100:_X_:=2; 1000:_X_:=3; 10000:_X_:=4;end;
    for a:=0 to size-1 do begin
     if not db then begin
       case acht(ts[a]) of
            0:case ts[a] of 0: nam:='Undialed'; 1: nam:='OutRanged'; end;
            8:nam:='Busy ('+no2str(ts[a] mod 8,1)+'times)';
            16:nam:='Excluded';
            24:nam:='Uninteresting('+no2str(ts[a] mod 8,1)+')';
            32:nam:='Timeout('+no2str(ts[a] mod 8,1)+')';
            40:nam:='Ringout('+no2str(ts[a] mod 8,1)+')';
            48:nam:='Unused';
            56:nam:='Manual';
            64:nam:=' No Carrier('+no2str(ts[a] mod 8,1)+')';
            72:nam:='Carrier('+no2str(ts[a] mod 8,1)+')';
            80:nam:='Carrier('+no2str(ts[a] mod 8,1)+') with Nudge';
            88:nam:='Carrier('+no2str(ts[a] mod 8,1)+') done manual hack';
            120:nam:='Fax('+no2str(ts[a] mod 8,1)+')';
            128:nam:='Voice('+no2str(ts[a] mod 8,1)+')';
            136:nam:='Interesting Voice('+no2str(ts[a] mod 8,1)+')';
            144:nam:='Girl Voice('+no2str(ts[a] mod 8,1)+')';
            152:nam:='Yelling Asshole Voice('+no2str(ts[a] mod 8,1)+')';
            168:nam:='Tone('+no2str(ts[a] mod 8,1)+')';
            176:nam:='Tone manually tried';
            192:nam:='VMB('+no2str(ts[a] mod 8,1)+')';
            200:nam:='VMB manually tried';
            224:nam:='Custom1('+no2str(ts[a] mod 8,1)+')';
            232:nam:='Custom2('+no2str(ts[a] mod 8,1)+')';
            240:nam:='Custom3('+no2str(ts[a] mod 8,1)+')';
            248:nam:='Unknown/Auto-Done('+no2str(ts[a] mod 8,1)+')';
       end;
       if nam='' then nam:='Reserved';
       if tmp<>'' then writeln(g,phone_no(a),'   ',nam) else writeln(g,no2str(a,_x_),'   ',nam);
    end else begin
       writeln(g,phone_no(a),'|',no2str(a,_x_),'|',id_2_name(ts[a],true),'|',
               id_2_name(ts[a],false),'|',ts[a],'|',ts[a] mod 8,'||||||||||||||||||||');
    end;
   end;
   if not db then begin
    writeln(g);
    mat1:=ts_head[29]*256; mat2:=ts_head[30]; mat:=mat1+mat2;
    writeln(g,Trunc(mat),' minutes used for scanning.');
   end;
   writeln(stdout,'Finished.');
   close(g);
end;

Procedure WriteOutPut;
begin
   if all then MakeLog else begin
   writeln(stdout,'Writing Phone Numbers of ID type ',id_name,' into ',name2);
   write(stdout,'Output type: ');
   if db then writeln(stdout,'GENERIC DATABASE FORMAT') else writeln(stdout,'ASCII TEXT FORMAT');

   if not db then begin
     writeln(g,'DAT File : ',name,' (created with THC-SCAN version v',Chr(ts_head[3]),'.',Chr(ts_head[4]),')');
     if tmp<>'' then writeln(g,'Dialmask : ',tmp) else writeln(g,'Dialmask : <none>'); writeln(g);
     writeln(g,'ID Type : ',id_name); writeln(g);
   end;
   count:=0;
   if tmp<>'' then begin _x_:=0;
      for a:=1 to length(tmp) do if tmp[a]='X' then inc(_x_);
      if _x_=0 then tmp:='';
      if (_x_=1)and(size<>10) then tmp:='';
      if (_x_=2)and(size<>100) then tmp:='';
      if (_x_=3)and(size<>1000) then tmp:='';
      if (_x_=4)and(size<>10000) then tmp:='';
      if _x_>4 then tmp:='';
   end;
   for a:=0 to size-1 do begin
      if id=0 then begin
         if ts[a]=0 then begin
            inc(count);
            if not db then begin
              if tmp<>'' then writeln(g,phone_no(a)) else writeln(g,no2str(a,_x_));
            end else begin
               writeln(g,phone_no(a),'|',no2str(a,_x_),'|',id_2_name(ts[a],true),'|',
                       id_2_name(ts[a],false),'|',ts[a],'|',ts[a] mod 8,'||||||||||||||||||||');
            end;
         end
     end else
      if ((ts[a] div id) = 1)and(ts[a] mod id < _id_mod) then begin
        inc(count);
        if not db then begin
          if tmp<>'' then writeln(g,phone_no(a)) else writeln(g,no2str(a,_x_));
        end else begin
           writeln(g,phone_no(a),'|',no2str(a,_x_),'|',id_2_name(ts[a],true),'|',
                   id_2_name(ts[a],false),'|',ts[a],'|',ts[a] mod 8,'||||||||||||||||||||');
        end;
      end;
   end;
   writeln(stdout,count,' entries written.');
   close(g);
end; end;

begin
   assign(stdout,''); rewrite(stdout);
   writeln(stdout,'DAT Statistics ',ver,author,email); writeln(stdout);
   Checkbreak:=false; SetCBreak(FALSE); all:=false;
   for a:=1 to 25 do stat[a]:=0;
   if (ParamCount=0)or(ParamCount>4) then help;
   if Pos('?',ParamStr(1))>0 then help;
   name:=ParamStr(1); UPC(name);
   if not CheckFile(name) then begin
      name:=name+'.DAT';
      if not CheckFile(name) then Error(1);
   end;
   size:=FSize(name); size:=size-32; name2:='';
   if (size<>10)and(size<>100)and(size<>1000)and(size<>10000) then Error(2);

   if Paramcount>=2 then begin
      name2:=paramstr(2); upc(name2);
      assign(g,name2); {I-} rewrite(g); {I+} if IoResult<>0 then Error(3);
      all:=true;
      if ParamCount>=3 then begin
         _tmp:=ParamStr(3); Upc(_tmp);
         if _tmp='DB' then db:=true else begin
            id_name:=_tmp;
            if not name_2_id(id_name, id) then error(4) else all:=false;
         end;
      end;
      if ParamCount=4 then begin
         _tmp:=ParamStr(4); Upc(_tmp);
         if _tmp='DB' then db:=true else begin
            id_name:=_tmp;
            if not name_2_id(id_name, id) then error(4) else all:=false;
         end;
      end;
   end;

   assign(f,name); reset(f,1);
   blockread(f,ts_head,32); blockread(f,ts,size); close(f);
   Stats; a:=5; tmp:='';
   while (ts_head[a]<>0)and(a<=32) do
         begin tmp:=tmp+Chr(ts_head[a]); inc(a); end;
   writeln(stdout,'DAT File : ',name,' (created with THC-SCAN version v',Chr(ts_head[3]),'.',Chr(ts_head[4]),')');
   if tmp<>'' then writeln(stdout,'Dialmask : ',tmp) else writeln(stdout,'Dialmask : <none>');
   writeln(stdout,'UnDialed :',stat[1]:5,' (',Proz(stat[1]):2,'%)');
   if stat[2]>0 then writeln(stdout,'Excluded :',stat[2]:5,' (',Proz(stat[2]),'%)');
   writeln(stdout,'Busy     :',stat[3]:5,' (',Proz(stat[3]):2,'%)');
   writeln(stdout,'Uninter. :',stat[4]:5,' (',Proz(stat[4]):2,'%)');
   writeln(stdout,'Timeout  :',stat[5]:5,' (',Proz(stat[5]):2,'%)');
   writeln(stdout,'Ringout  :',stat[6]:5,' (',Proz(stat[6]):2,'%)');
           a:=stat[9]+stat[10]+stat[11]+stat[12];
   if stat[13]>0 then writeln(stdout,'Fax      :',stat[13]:5,' (',Proz(stat[13]):2,'%)');
   writeln(stdout,'Carriers :',a:5,' (',Proz(a):2,'%)');
   writeln(stdout,'Tones    :',stat[18]:5,' (',Proz(stat[18]):2,'%)');
           a:=stat[14]+stat[15]+stat[16]+stat[17];
   writeln(stdout,'Voice    :',a:5,' (',Proz(a):2,'%)  [Std:',stat[14],'/I:',stat[15],'/G:',stat[16],'/Y:',stat[17],']');
   writeln(stdout,'VMB      :',stat[19]:5,' (',Proz(stat[19]):2,'%)');
           a:=stat[20]+stat[21]+stat[22];
   writeln(stdout,'Custom   :',a:5,' (',Proz(a):2,'%)  [1:',stat[20],'/2:',stat[21],'/3:',stat[22],']');
   if stat[7]>0 then writeln(stdout,'Unused   :',stat[7]:5,' (',Proz(stat[7]):2,'%)');
   if stat[8]>0 then writeln(stdout,'Manual   :',stat[8]:5,' (',Proz(stat[8]):2,'%)');
   if stat[23]>0 then writeln(stdout,'Done     :',stat[23]:5,' (',Proz(stat[23]):2,'%)');
   mat1:=ts_head[29]*256; mat2:=ts_head[30]; mat:=mat1+mat2;
   writeln(stdout);
   writeln(stdout,Trunc(mat),' minutes used for scanning.');
   if name2<>'' then WriteOutput;
   close(stdout);
end.
