{ͻ
  Unit      _Menue.pas                                   
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      27.03.90                                     
                                                         
  Update    18.04.91                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Pull-Down-Men-Routinen.                     
 ͼ}
Unit _Menue;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  Crt,                     {Unit aus dem Turbo Pascal-System}
  _Declare;                         {Unit aus dem Unitsystem}

const {Globale Konstanten}
  _MaxMainPkt = 10;          {Maximal 10 Hauptauswahlpunkte}
  _MaxSubPkt  = 15;             {Maximal 15 Untermenpunkte}
  _SubTextColor : byte = Black;        {Vordergrund Submen}
  _SubBackColor : byte = LightGray;    {Hintergrund Submen}
  _SubMenuRand  : byte = 1;              {Schmale Umrandung}
  _MainAnf      : byte = 1;                {Anfangsposition}

type {Globale Datentypen}
  {Initialisierungstyp fr Hauptmenleiste}
  _MainMenuRec = array[1.._MaxMainPkt] of
                   record
                     Bez: _Str15;              {Bezeichnung}
                     Sub: boolean;   {Ob Sub-Men vorhanden}
                     Key: char;                     {HotKey}
                     x,y: byte;               {Spalte/Zeile}
                   end;

  {Wird fr alle Sub-Mens benutzt}
  _SubMenuRec  = array[1.._MaxSubPkt] of
                  record
                    Bez: _Str30;
                    Key: char;
                  end;

var {Globale Variablen}
  _Main: _MainMenuRec;                  {Hauptauswahlleiste}
  _Sub : _SubMenuRec;                              {Submen}

  {Verzeichnis der globalen Routinen}

  function _PullDownMenu(Main: _MainMenuRec;
                         Anz: byte): integer;

  procedure _InitSubMenu(Nr,Anz,MaxLen:byte;
                         Sub: _SubMenuRec);

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  _Windows,_IO,
  _Check,_Input;                   {Units aus dem Unitsystem}

type {Lokale Datentypen}
  SubMenu = array[1.._MaxMainPkt] of
              record
                Anz  : byte;
                x1,y1,
                x2,y2: byte;
                Bez  : array[1.._MaxSubPkt] of _Str30;
                Key  : array[1.._MaxSubPkt] of char;
                Len  : byte;
              end;

var {Lokale Variablen}
  SMenu  : SubMenu;              {Fr Routine _PullDownMenu}
  SubVorh: array[1.._MaxMainPkt]     {Ob Submens vorhanden}
             of boolean;

{ͻ
  SubVorandenInit                                         
 Ķ
  Initialisiert beim Aufruf der Unit, da zu keinem Aus-  
  wahlpunkt des Hauptmens ein Submen existiert (False). 
 ͼ}
procedure SubVorhandenInit;
var i: byte;

begin
  for i:= 1 to _MaxMainPkt do
   SubVorh[i]:= false;
end;
{ͻ
  _InitSubMenu                                            
 Ķ
  Nr    : Nr des zu initialisierenden Submens            
  Anz   : Anzahl Auswahlpunkte im Submen                 
  MaxLen: Wert des lngsten Auswahlpunktes                
  Sub   : Angaben zu den Submens                         
                                                          
  Initialisiert des Submen mit der Ordnungsnummer Nr. Die
  Position (x1,y1,x2,y2) kann erst initialisiert werden,  
  wenn das Hauptmen aufgerufen wird, weil deren Position 
  z.Zt. noch nicht bekannt ist.                           
 ͼ}
procedure _InitSubMenu(Nr,Anz,MaxLen:byte;Sub: _SubMenuRec);
var
  i: byte;                                    {Zhlvariable}

begin
  SMenu[Nr].Anz:= Anz;
  SMenu[Nr].Len:= MaxLen;
  for i:= 1 to Anz do
  begin
    SMenu[Nr].Bez[i]:= Sub[i].Bez;
    SMenu[Nr].Key[i]:= Sub[i].Key;
  end;
end;
{ͻ
  SubAuswahl                                              
 Ķ
                                                          
  Nr     : Var-Parameter fr zu ffnendes Submen und zu- 
           letzt geffnetes Fenster                       
  Main   : Angaben zur Hauptmenleiste                    
  MLeiste: Angabe zur Hauptauswahlleiste                  
  Anz    : Anzahl Hauptauswahlpunkte                      
                                                          
  bernimmt die Steuerung der Auswahl in einem Submen.   
  Der ausgewhlte Menpunkt wird als Ergebnis der Funktion
  zurckgeliefert. Wird das Submen mit <Esc> verlassen,  
  ist das Ergebnis 0.                                      
 ͼ}
function SubAuswahl(var Nr: integer; Main: _MainMenuRec;
                    MLeiste: _Leiste;Anz: byte): integer;
var
  SubLeiste: _Leiste;
  Erg      : integer;                     {Ergebnis Submen}
  i        : integer;                 {Auswahl und Ergebnis}
  ch       : char;                             {Tastendruck}
  ok       : boolean;                      {Auswahl beendet}

{WindowInit}
{Initialisiert das entsprechende Fenster}
procedure WindowInit(N: byte);
var
  j        : byte;                            {Zhlvariable}

begin
  _MakeWin(_MaxWin,SMenu[N].x1,SMenu[N].y1,
                   SMenu[N].x2,SMenu[N].y2,
                   _SubMenuRand,
                   _SubTextColor,_SubBackColor,
                   '','');
  {SubLeiste initialisieren}
  for j:= 1 to SMenu[N].Anz do
  begin
    SubLeiste[j].Bez:= SMenu[N].Bez[j];
    SubLeiste[j].Sp := 2;
    SubLeiste[j].Zei:= j;
  end;
  {Subleiste schreiben}
  for j:= 1 to SMenu[N].Anz do
  begin
    _Write(SubLeiste[j].Sp,SubLeiste[j].Zei,
           SubLeiste[j].Bez);
  end;
end;
{RichtungSub}
{Bewegung innerhalb eines Submens}
procedure RichtungSub;
begin
  _SetTempColor(_SubTextColor,_SubBackColor,false);
  _Write(SubLeiste[i].Sp,SubLeiste[i].Zei,
         SubLeiste[i].Bez);
  case ch of
    _Up  : begin                        {Ein Feld nach oben}
             Dec(i);
             if i < 1 then i:= SMenu[Nr].Anz;
           end;
    _Dn  : begin                       {Ein Feld nach unten}
             Inc(i);
             if i > SMenu[Nr].Anz then i:= 1;
           end;
    _Home: i:= 1;                           {Ins erste Feld}
    _End : i:= SMenu[Nr].Anz;              {Ins letzte Feld}
  end; {case}
  _WriteInv(SubLeiste[i].Sp,SubLeiste[i].Zei,
            SubLeiste[i].Bez);
  _GetOldColor(false);
end;
{SeitwaertsSub}
{Bewegung zum nchsten Submen}
procedure SeitwaertsSub;
begin
  _RestoreScr;                         {Letztes Bild zurck}
  _NormWindow;                       {Volle Bildschirmgre}
  _Write(MLeiste[Nr].Sp,MLeiste[Nr].Zei,MLeiste[Nr].Bez);
  case ch of
    _Left : begin                   {Nchstes Submen links}
              repeat
                Dec(Nr);
                if Nr < 1 then Nr:= Anz;
              until SubVorh[Nr];
            end;
    _Right: begin                  {Nchstes Submen rechts}
              repeat
                Inc(Nr);
                if Nr > Anz then Nr:= 1;
              until SubVorh[Nr];
            end;
  end; {case}
  _WriteInv(MLeiste[Nr].Sp,MLeiste[Nr].Zei,MLeiste[Nr].Bez);
  _SaveScr;                            {Bild wieder sichern}
end;
{KeyTasten}
{Werden nur im entsprechenden Submen gesucht}
procedure KeyTastenSub;
var j: byte;

begin
  j:= 0;                                       {Anfangswert}
  while (ch <> _Cr) and (j < SMenu[Nr].Anz) do
  begin
    Inc(j);
    if SMenu[Nr].Key[j] = ch then
    begin
      Erg:= (Nr * 100) + j;             {Key-Taste gefunden}
      ch:= _Cr;                  {Suche und Auswahl beenden}
    end;
  end; {while}
end;
{FTastenSub}
procedure FTasten;
var
  j,k: byte;                                 {Zhlvariablen}

begin
  {Zuerst Hauptmen durchsuchen}
  j:= 0;                                       {Anfangswert}
  while (ch <> _Cr) and (j < Anz) do
  begin
    Inc(j);
    if Main[j].Key = ch then
    begin
      _RestoreScr;                     {Letztes Bild zurck}
      _NormWindow;                   {Volle Bildschirmgre}
      _Write(MLeiste[Nr].Sp,MLeiste[Nr].Zei,
             MLeiste[Nr].Bez);
      Nr:= j;                           {Key-Taste gefunden}
      Erg:= j;
      ch:= _Cr;                  {Suche und Auswahl beenden}
      _WriteInv(MLeiste[Nr].Sp,MLeiste[Nr].Zei,
                MLeiste[Nr].Bez);
      _SaveScr;                        {Bild wieder sichern}
      Exit;                             {Prozedur verlassen}
    end; {if}
  end; {while}
  {Wenn Key nicht gefunden, dann Submens durchsuchen}
  for j:= 1 to Anz do
  begin
    if SubVorh[j] then
    begin
      for k:= 1 to SMenu[j].Anz do
      begin
        if SMenu[j].Key[k] = ch then
        begin
          _RestoreScr;                 {Letztes Bild zurck}
          _NormWindow;               {Volle Bildschirmgre}
          _Write(MLeiste[Nr].Sp,MLeiste[Nr].Zei,
                 MLeiste[Nr].Bez);
          Erg:= (j * 100) + k;
          ch:= _Cr;              {Suche und Auswahl beenden}
          _WriteInv(MLeiste[(Erg div 100)].Sp,
                    MLeiste[(Erg div 100)].Zei,
                    MLeiste[(Erg div 100)].Bez);
          _SaveScr;                    {Bild wieder sichern}
          Exit;                         {Prozedur verlassen}
        end; {if}
      end; {for k}
    end; {if}
  end; {for j}
  Erg:= Nr;
end;
{}

begin                                           {SubAuswahl}
  ok:= false;                   {Noch keine Auswahl Submen}
  repeat
    _SaveScr;                           {Bildschirm sichern}
    WindowInit(Nr);                 {Fenster initialisieren}
    i:= 1;
    _SetTempColor(_SubTextColor,_SubBackColor,false);
    _WriteInv(SubLeiste[i].Sp,SubLeiste[i].Zei,
              SubLeiste[i].Bez);
    _GetOldColor(false);
    ch:= ' ';
    while ch <> _Cr do
    begin
      _CursorAus;
      ch:= _Upcase(_Readkey);
      _CursorEin;
      if ch <> _Cr
      then begin
             case ch of
               _Esc        : begin       {Submen verlassen}
                               Erg:= 0;
                               ch:= _Cr;
                               ok:= true;
                             end;
               _Dn,_Up,
               _Home,_End  : RichtungSub;
               _Left,_Right: begin        {Nchstes Submen}
                               SeitwaertsSub;
                               ch:= _Cr;
                               ok:= false;
                             end;
               'A'..'Z',
               '0'..'9'    : begin
                               KeyTastenSub;
                               ok:= true;
                             end;
               else
                 FTasten;
                 ok:= true;
                 if (Erg = Nr) and SubVorh[Nr]
                  then ok:= false;
             end; {case}
           end {if}
      else begin
             Erg:= (Nr * 100) + i;
             ok:= true;
           end;
    end; {while}
    _RestoreScr;                         {Bildschirm zurck}
    _NormWindow;                     {Volle Bildschirmgre}
  until ok;                            {Bis Auswahl beendet}
  SubAuswahl:= Erg;
end;
{ͻ
  MainAuswahl                                             
 Ķ
                                                          
  Main  : Record mit Angaben zum Hauptmen                
  Leiste: Beinhaltet die Auswahlpunkte des Hauptmens     
  Anz   : Anzahl der Auswahlpunkte des Hauptmens         
                                                          
  Die Auswahlpunkte werden zeilenweise auf dem Bildschirm 
  angeordnet. Die Auswahl geschieht mit den Cursortasten, 
  [Home]/[End] oder evtl. Key-Tasten. Die Ordnungszahl des
  mit [Cr] oder einer Key-Taste ausgewhlten Punktes wird 
  als Ergebnis d. Funktion zurckgeliefert. Verzweigt evtl
  in ein Submen (Prozedur SubAuswahl).                   
 ͼ}
function MainAuswahl(Main   : _MainMenuRec;
                     Leiste : _Leiste;
                     Anz    : byte): integer;

var
  i,                             {Zhlvariable und Ergebnis}
  Erg: integer;                           {Ergebnis Submen}
  ch : char;                                   {Tastendruck}
  ok : boolean;               {Ob ausfhrbarer Auswahlpunkt}

{Richtung}
{Pfeiltasten [Links],[Rechts] und [Home],[End]}
procedure Richtung;
begin
  _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  case ch of
    _Left : begin                               {Nach links}
              Dec(i);
              if i < 1 then i:= Anz;
            end;
    _Right: begin                              {Nach rechts}
              Inc(i);
              if i > Anz then i:= 1;
            end;
    _Home : i:= 1;                     {Erster Auswahlpunkt}
    _End  : i:= Anz;                  {Letzter Auswahlpunkt}
  end; {case}
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  GotoXY(Leiste[i].Sp,Leiste[i].Zei);
end;
{KeyTasten}
procedure KeyTasten;
var j: byte;

begin
  _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  j:= 0;                                       {Anfangswert}
  while (ch <> _Cr) and (j < Anz) do
  begin
    Inc(j);
    if Main[j].Key = ch then
    begin
      i:= j;                            {Key-Taste gefunden}
      ch:= _Cr;                  {Suche und Auswahl beenden}
    end;
  end; {while}
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
end;
{FTasten}
procedure FTasten;
var
  j,k: byte;                                 {Zhlvariablen}

begin
  {Zuerst Hauptmen durchsuchen}
  j:= 0;                                       {Anfangswert}
  while (ch <> _Cr) and (j < Anz) do
  begin
    Inc(j);
    if Main[j].Key = ch then
    begin
      _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
      i:= j;                            {Key-Taste gefunden}
      ch:= _Cr;                  {Suche und Auswahl beenden}
      _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
      Exit;                             {Prozedur verlassen}
    end; {if}
  end; {while}
  {Wenn Key nicht gefunden, dann Submens durchsuchen}
  for j:= 1 to Anz do
  begin
    if SubVorh[j] then
    begin
      for k:= 1 to SMenu[j].Anz do
      begin
        if SMenu[j].Key[k] = ch then
        begin
          _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
          i:= (j * 100) + k;
          ch:= _Cr;              {Suche und Auswahl beenden}
          _WriteInv(Leiste[(i div 100)].Sp,
                    Leiste[(i div 100)].Zei,
                    Leiste[(i div 100)].Bez);
          Exit;                         {Prozedur verlassen}
        end; {if}
      end; {for k}
    end; {if}
  end; {for j}
end;
{}

begin                                          {MainAuswahl}
  {Vorarbeiten leisten}
  for i:= 1 to Anz do
    _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  i:= _MainAnf;                            {Anfangsposition}
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  ch:= ' ';
  ok:= false;          {Noch kein ausfhrbarer Auswahlpunkt}
  repeat
    {Tastendruck auswerten}
    while ch <> _Cr do
    begin
      _CursorAus;
      ch:= _Upcase(_Readkey);
      _CursorEin;
      if ch <> _Cr then
      begin
        case ch of
          _Esc          : begin        {Hauptmen verlassen}
                            i:= 0;
                            ch:= _Cr;
                          end;
          _Left,_Right,
          _Home,_End    : Richtung;
          'A'..'Z',
          '0'..'9'      : KeyTasten;
          else            FTasten;
        end; {case}
      end; {if}
    end; {while}
    {Wenn Hauptleiste nicht mit <Esc> beendet}
    {und keine Auswahl aus Submen mit Key-Taste}
    if _IntRange(1,_MaxMainPkt,i)
    then begin {(1)}
           if SubVorh[i]
           then begin {(2)}
                  Erg:= SubAuswahl(i,Main,Leiste,Anz);
                  {Wenn Submen nicht mit <Esc> verl.}
                  if Erg <> 0
                  then begin     {Ausfhrbarer Auswahlpunkt}
                         i:= Erg;
                         ok:= true;
                       end
                  else ch:= ' ';        {Wieder Hauptleiste}
                end {if (2)}
           else ok:= true;       {Ausfhrbarer Auswahlpunkt}
         end {if (1)}
    else ok:= true;              {Ausfhrbarer Auswahlpunkt}
  until ok;         {Bis ausfhrbarer Auswahlpunkt vorliegt}
  MainAuswahl:= i;
end;
{ͻ
  _PullDownMenu                                           
 Ķ
                                                          
  Main: Record mit Angaben zum Hauptmen                  
  Anz : Anzahl Hauptmenpunkte                            
                                                          
  bernimmt die gesamte Steuerung des Mensystems. Main-  
  men und Submens werden initialisiert. ber den Aufruf 
  der Routine MainAuswahl wird die Auswahl eines Men-    
  punktes gesteuert. Menpunkte, die kein Submen haben,  
  liefern bei der Auswahl ihre Ordnungsnummer als Ergebnis
  an das aufrufende Programm zurck. Ausgewhlte Menpkt. 
  eines Submens liefern als Ergebnis die zugehrige Ord- 
  nungsnummer des Hauptmens multipliziert mit 100 plus   
  der Ordnungsnummer des ausgewhlten Menpunktes im Sub- 
  men: Erg:= (M * 100) + S.                              
 ͼ}
function _PullDownMenu(Main: _MainMenuRec;
                       Anz: byte): integer;

var
  MainLeiste   : _Leiste;                 {Hauptmen-Leiste}
  ErgMainLeiste: integer;        {Ergebnis Hauptmen-Leiste}
  i            : byte;                        {Zhlvariable}

begin
  {Initialisieren, ob Submens vorhanden}
  for i:= 1 to Anz do
    if Main[i].Sub then SubVorh[i]:= true;
  {Position (x1,y1,x2,y2) Submens initialisieren}
  for i:= 1 to Anz do
  begin
    if SubVorh[i] then {(1)}
    begin
      SMenu[i].x1:= Main[i].x;
      SMenu[i].y1:= Main[i].y + 2;
      SMenu[i].x2:= Main[i].x + 3 + SMenu[i].Len;
      SMenu[i].y2:= SMenu[i].y1 + 1 + SMenu[i].Anz;
      {Ob Spalte X2 vom Submen > 79}
      if SMenu[i].x2 > 79 then {(2)}
      begin
        while SMenu[i].x2 > 79 do
        begin
          Dec(SMenu[i].x2);
          Dec(SMenu[i].x1);
        end; {while}
      end; {if-then (2)}
    end; {if-then (1)}
  end; {for}
  {Hauptmen-Leiste initialisieren}
  for i:= 1 to Anz do
  begin
    MainLeiste[i].Bez:= Main[i].Bez;
    MainLeiste[i].Sp := Main[i].x;
    MainLeiste[i].Zei:= Main[i].y;
  end;
  {Hauptmen-Leiste auf Bildschirm}
  ErgMainLeiste:= MainAuswahl(Main,MainLeiste,Anz);
  {Letzten Auswahlpunkt Mainmen festhalten}
  if ErgMainLeiste > Anz
  then _MainAnf:= ErgMainLeiste div 100
  else begin
         if ErgMainLeiste = 0
         then _MainAnf:= 1
         else _MainAnf:= ErgMainLeiste;
       end;
  {Ergebnis Wahl Hauptmen-Leiste auswerten}
  _PullDownMenu:= ErgMainLeiste;
end;
{ͻ
  Initialisierungs-Teil (Ausfhrungsteil)                 
 ͼ}
begin
  SubVorhandenInit;              {Initialisierung mit False}
{ͻ
  End of Unit                                             
 ͼ}
end.